% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstsm.R
\name{gstsm}
\alias{gstsm}
\title{Algorithm 1: G-STSM}
\usage{
gstsm(sts_dataset, spatial_positions, gamma, beta, sigma)
}
\arguments{
\item{sts_dataset}{STS dataset}

\item{spatial_positions}{set of spatial positions}

\item{gamma}{minimum temporal frequency}

\item{beta}{minimum group size}

\item{sigma}{max distance between group points}
}
\value{
Solid-Raged-Groups.
}
\description{
This section presents the G-STSM. Our algorithm is designed to the
identification of frequent sequences in STS datasets from the concept of SRG.
The notion of ranged-group (RG, KRG, and SRG) introduced in the previous
section enables for extracting SRG efficiently.
The G-STSM is based on the candidate-generating principle. Our goal is
to start finding SRGs for sequences of size one. Then we explore the support
and the number of occurrences of SRGs for larger sequences with a limited
number of scans over the database. To this end, we need to find the range and
the set of positions (i. e., the SRG) in which a candidate sequence is
frequent in only one scan.
}
\examples{
library("gstsm")
events_data_path <-
  system.file("extdata", "made_bangu_6x30.txt", package = "gstsm")

space_time_data_path <-
  system.file("extdata", "positions_2D_30.txt", package = "gstsm")

d <- read.table(
  events_data_path,
  header = FALSE,
  sep = " ",
  dec = ".",
  as.is = TRUE,
  stringsAsFactors = FALSE
)

p <- read.table(
  space_time_data_path,
  header = TRUE,
  sep = " ",
  dec = ".",
  as.is = TRUE,
  stringsAsFactors = FALSE
)

gamma <- 0.8
beta <- 2
sigma <- 1

result <- gstsm::gstsm(d, p, gamma, beta, sigma)
}
