% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SA_from_Sstar}
\alias{gsw_SA_from_Sstar}
\title{Absolute Salinity from Preformed Salinity}
\usage{
gsw_SA_from_Sstar(Sstar, p, longitude, latitude)
}
\arguments{
\item{Sstar}{Preformed Salinity [ g/kg ]}

\item{p}{sea pressure [ dbar ]}

\item{longitude}{longitude in decimal degrees [ 0 to 360 or -180 to 180]}

\item{latitude}{latitude in decimal degrees [ -90 to 90 ]}
}
\value{
Absolute Salinity [ g/kg ]
}
\description{
Calculate Absolute Salinity from Preformed Salinity, pressure,
longitude, and latitude.
}
\details{
If Sstar is a matrix and if its dimensions correspond to the
lengths of longitude and latitude, then the latter are
converted to analogous matrices with \code{\link{expand.grid}}.
}
\examples{
gsw_SA_from_Sstar(34.7115, 10, 188, 4) # 34.711724663585905
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SA_from_Sstar.html}
}
\seealso{
\code{\link{gsw_Sstar_from_SA}} does the reverse.
}

