% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_alpha_wrt_t_exact}
\alias{gsw_alpha_wrt_t_exact}
\title{Thermal expansion coefficient with respect to in-situ temperature}
\usage{
gsw_alpha_wrt_t_exact(SA, t, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90)  [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
thermal expansion coefficient with respect to in-situ temperature [ 1/K ]
}
\description{
Thermal expansion coefficient with respect to in-situ temperature
}
\examples{
gsw_alpha_wrt_t_exact(34.7118, 28.7856, 10) # 1e-3*0.325601747227247
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_alpha_wrt_t_exact.html}
}
\seealso{
\code{\link{gsw_alpha}}, \code{\link{gsw_beta}} and \code{\link{gsw_alpha_on_beta}}
}

