% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pot_rho_t_exact}
\alias{gsw_pot_rho_t_exact}
\title{Potential density}
\usage{
gsw_pot_rho_t_exact(SA, t, p, p_ref)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ deg C ]}

\item{p}{sea pressure [ dbar ]}

\item{p_ref}{reference pressure [ dbar ]}
}
\value{
potential density [ kg/m^3 ]
}
\description{
Potential density
}
\examples{
gsw_pot_rho_t_exact(34.7118, 28.7856, 10, 0) # 1021.798145811089
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pot_rho_t_exact.html}
}
\seealso{
\code{\link{gsw_rho}} and \code{\link{gsw_rho_t_exact}} compute density; \code{\link{gsw_sigma0}} and related functions compute potential density at particular pressures.
}

