% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_sigma1}
\alias{gsw_sigma1}
\title{Potential density anomaly referenced to 1000 dbar}
\usage{
gsw_sigma1(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}
}
\value{
potential density anomaly [ kg/m^3 ]
}
\description{
This uses the 48-term density equation, and returns
potential density referenced to a pressure of 1000 dbar,
minus 1000 kg/m^3.
}
\examples{
gsw_sigma1(34.7118, 28.8099) # 25.955891533636986
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_sigma1.html}
}
\seealso{
Use \code{\link{gsw_sigma0}} for 0 dbar pressure, \code{\link{gsw_sigma2}} for 2000 dbar, \code{\link{gsw_sigma3}} for 3000 dbar, or \code{\link{gsw_sigma4}} for 4000 dbar.
}

