% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_rows.R
\name{summary_rows}
\alias{summary_rows}
\title{Add groupwise summary rows using aggregation functions}
\usage{
summary_rows(
  data,
  groups = NULL,
  columns = TRUE,
  fns,
  missing_text = "---",
  formatter = fmt_number,
  ...
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{groups}{The groups to consider for generation of groupwise summary
rows. By default this is set to \code{NULL}, which results in the formation of
grand summary rows (a grand summary operates on all table data). Providing
the names of row groups in \code{\link[=c]{c()}} will create a groupwise summary and
generate summary rows for the specified groups. Setting this to \code{TRUE}
indicates that all available groups will receive groupwise summary rows.}

\item{columns}{The columns for which the summaries should be calculated.}

\item{fns}{Functions used for aggregations. This can include base functions
like \code{mean}, \code{min}, \code{max}, \code{median}, \code{sd}, or \code{sum} or any other
user-defined aggregation function. The function(s) should be supplied
within a \code{list()}. Within that list, we can specify the functions by use of
function names in quotes (e.g., \code{"sum"}), as bare functions (e.g., \code{sum}),
or as one-sided R formulas using a leading \code{~}. In the formula
representation, a \code{.} serves as the data to be summarized (e.g., \code{sum(., na.rm = TRUE)}). The use of named arguments is recommended as the names
will serve as summary row labels for the corresponding summary rows data
(the labels can derived from the function names but only when not providing
bare function names).}

\item{missing_text}{The text to be used in place of \code{NA} values in summary
cells with no data outputs.}

\item{formatter}{A formatter function name. These can be any of the \verb{fmt_*()}
functions available in the package (e.g., \code{\link[=fmt_number]{fmt_number()}}, \code{\link[=fmt_percent]{fmt_percent()}},
etc.), or a custom function using \code{fmt()}. The default function is
\code{\link[=fmt_number]{fmt_number()}} and its options can be accessed through \code{...}.}

\item{...}{Values passed to the \code{formatter} function, where the provided
values are to be in the form of named vectors. For example, when using the
default \code{formatter} function, \code{\link[=fmt_number]{fmt_number()}}, options such as \code{decimals},
\code{use_seps}, and \code{locale} can be used.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Add summary rows to one or more row groups by using the table data and any
suitable aggregation functions. You choose how to format the values in the
resulting summary cells by use of a \code{formatter} function (e.g, \code{fmt_number},
etc.) and any relevant options.
}
\details{
Should we need to obtain the summary data for external purposes, the
\code{\link[=extract_summary]{extract_summary()}} function can be used with a \code{gt_tbl} object where summary
rows were added via \code{summary_rows()}.
}
\section{Figures}{

\if{html}{\figure{man_summary_rows_1.png}{options: width=100\%}}
}

\section{Function ID}{

6-1
}

\examples{
# Use `sp500` to create a gt table with
# row groups; create summary rows (`min`,
# `max`, `avg`) by row group, where each
# each row group is a week number
tab_1 <-
  sp500 \%>\%
  dplyr::filter(
    date >= "2015-01-05" &
      date <="2015-01-16"
  ) \%>\%
  dplyr::arrange(date) \%>\%
  dplyr::mutate(
    week = paste0(
      "W", strftime(date, format = "\%V"))
  ) \%>\%
  dplyr::select(-adj_close, -volume) \%>\%
  gt(
    rowname_col = "date",
    groupname_col = "week"
  ) \%>\%
  summary_rows(
    groups = TRUE,
    columns = vars(open, high, low, close),
    fns = list(
      min = ~min(.),
      max = ~max(.),
      avg = ~mean(.)),
    formatter = fmt_number,
    use_seps = FALSE
  )

}
\seealso{
Other Add Rows: 
\code{\link{grand_summary_rows}()}
}
\concept{Add Rows}
