% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_align_table_header}
\alias{opt_align_table_header}
\title{Option to align the table header}
\usage{
opt_align_table_header(data, align = c("left", "center", "right"))
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{align}{The alignment of the title and subtitle elements in the table
header. Options are \code{"left"} (the default), \code{"center"}, or \code{"right"}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
By default, a table header added to a \strong{gt} table has center alignment
for both the title and the subtitle elements. This function allows us to
easily set the horizontal alignment of the title and subtitle to the left
or right by using the \code{"align"} argument. This function serves as a
convenient shortcut for \verb{<gt_tbl> \%>\% tab_options(heading.align = <align>)}.
}
\section{Figures}{

\if{html}{\figure{man_opt_align_table_header_1.png}{options: width=100\%}}
}

\section{Function ID}{

9-3
}

\examples{
# Use `exibble` to create a gt table with
# a number of table parts added; the header
# (consisting of the title and the subtitle)
# are to be aligned to the left with the
# `opt_align_table_header()` function
tab_1 <-
  exibble \%>\%
  gt(rowname_col = "row", groupname_col = "group") \%>\%
  summary_rows(
    groups = "grp_a",
    columns = c(num, currency),
    fns = list(
      min = ~min(., na.rm = TRUE),
      max = ~max(., na.rm = TRUE)
    )) \%>\%
  grand_summary_rows(
    columns = currency,
    fns = list(
      total = ~sum(., na.rm = TRUE)
    )) \%>\%
  tab_source_note(source_note = "This is a source note.") \%>\%
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) \%>\%
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) \%>\%
  opt_align_table_header(align = "left")

}
\seealso{
Other Table Option Functions: 
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{Table Option Functions}
