% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_stubhead}
\alias{tab_stubhead}
\title{Add label text to the stubhead}
\usage{
tab_stubhead(data, label)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{label}{The text to be used as the stubhead label We can optionally use
the \code{\link[=md]{md()}} and \code{\link[=html]{html()}} functions to style the text as Markdown or to
retain HTML elements in the text.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Add a label to the stubhead of a \strong{gt} table. The stubhead is the lone
element that is positioned left of the column labels, and above the stub. If
a stub does not exist, then there is no stubhead (so no change will be made
when using this function in that case). We have the flexibility to use
Markdown formatting for the stubhead label. Furthermore, if the table is
intended for HTML output, we can use HTML for the stubhead label.
}
\section{Figures}{

\if{html}{\figure{man_tab_stubhead_1.png}{options: width=100\%}}
}

\section{Function ID}{

2-5
}

\examples{
# Use `gtcars` to create a gt table; add
# a stubhead label to describe what is
# in the stub
tab_1 <-
  gtcars \%>\%
  dplyr::select(model, year, hp, trq) \%>\%
  dplyr::slice(1:5) \%>\%
  gt(rowname_col = "model") \%>\%
  tab_stubhead(label = "car")

}
\seealso{
Other Create or Modify Parts: 
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_style}()}
}
\concept{Create or Modify Parts}
