% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{as_word}
\alias{as_word}
\title{Output a \strong{gt} object as Word}
\usage{
as_word(
  data,
  align = "center",
  caption_location = c("top", "bottom", "embed"),
  caption_align = "left",
  split = FALSE,
  keep_with_next = TRUE
)
}
\arguments{
\item{data}{A table object that is created using the \code{gt()} function.}

\item{align}{An option for table alignment. Can either be \code{"center"} (the
default), \code{"left"}, or \code{"right"}.}

\item{caption_location}{Determines where the caption should be positioned.
This can either be \code{"top"} (the default), \code{"bottom"}, or \code{"embed"}.}

\item{caption_align}{Determines the alignment of the caption. This is
either \code{"left"} (the default), \code{"center"}, or \code{"right"}. This option is
only used when \code{caption_location} is not set as \code{"embed"}.}

\item{split}{A \code{TRUE} or \code{FALSE} (the default) value that indicates whether
to activate the Word option \verb{Allow row to break across pages}.}

\item{keep_with_next}{A \code{TRUE} (the default) or \code{FALSE} value that indicates
whether a table should use Word option \verb{keep rows together}.}
}
\description{
Get the Open Office XML table tag content from a \code{gt_tbl} object as as a
single-element character vector.
}
\section{Examples}{


Use \code{\link{gtcars}} to create a \strong{gt} table. Add a header and then export as
OOXML code for Word.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_rtf <-
  gtcars |>
  dplyr::select(mfr, model) |>
  dplyr::slice(1:2) |>
  gt() |>
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  ) |>
  as_word()
}\if{html}{\out{</div>}}
}

\section{Function ID}{

13-5
}

\section{Function Introduced}{

\code{v0.7.0} (August 25, 2022)
}

\seealso{
Other table export functions: 
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_rtf}()},
\code{\link{extract_cells}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{table export functions}
