% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_partsper}
\alias{fmt_partsper}
\title{Format values as parts-per quantities}
\usage{
fmt_partsper(
  data,
  columns = everything(),
  rows = everything(),
  to_units = c("per-mille", "per-myriad", "pcm", "ppm", "ppb", "ppt", "ppq"),
  symbol = "auto",
  decimals = 2,
  drop_trailing_zeros = FALSE,
  drop_trailing_dec_mark = TRUE,
  scale_values = TRUE,
  use_seps = TRUE,
  pattern = "{x}",
  sep_mark = ",",
  dec_mark = ".",
  force_sign = FALSE,
  incl_space = "auto",
  system = c("intl", "ind"),
  locale = NULL
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=c]{c()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Providing \code{\link[=everything]{everything()}} (the
default) results in all rows in \code{columns} being formatted. Alternatively,
we can supply a vector of row captions within \code{\link[=c]{c()}}, a vector of row
indices, or a helper function focused on selections. The select helper
functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions
to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{to_units}{A keyword that signifies the desired output quantity. This
can be any from the following set: \code{"per-mille"}, \code{"per-myriad"}, \code{"pcm"},
\code{"ppm"}, \code{"ppb"}, \code{"ppt"}, or \code{"ppq"}.}

\item{symbol}{The symbol/units to use for the quantity. By default, this is
set to \code{"auto"} and \strong{gt} will choose the appropriate symbol based on the
\code{to_units} keyword and the output context. However, this can be changed by
supplying a string (e.g, using \code{symbol = "ppbV"} when \code{to_units = "ppb"}).}

\item{decimals}{An option to specify the exact number of decimal places to
use. The default number of decimal places is \code{2}.}

\item{drop_trailing_zeros}{A logical value that allows for removal of
trailing zeros (those redundant zeros after the decimal mark).}

\item{drop_trailing_dec_mark}{A logical value that determines whether decimal
marks should always appear even if there are no decimal digits to display
after formatting (e.g, \code{23} becomes \code{23.}). The default for this is \code{TRUE},
which means that trailing decimal marks are not shown.}

\item{scale_values}{Should the values be scaled through multiplication
according to the keyword set in \code{to_units}? By default this is \code{TRUE} since
the expectation is that normally values are proportions. Setting to \code{FALSE}
signifies that the values are already scaled and require only the
appropriate symbol/units when formatted.}

\item{use_seps}{An option to use digit group separators. The type of digit
group separator is set by \code{sep_mark} and overridden if a locale ID is
provided to \code{locale}. This setting is \code{TRUE} by default.}

\item{pattern}{A formatting pattern that allows for decoration of the
formatted value. The value itself is represented by \code{{x}} and all other
characters are taken to be string literals.}

\item{sep_mark}{The mark to use as a separator between groups of digits
(e.g., using \code{sep_mark = ","} with \code{1000} would result in a formatted value
of \verb{1,000}).}

\item{dec_mark}{The character to use as a decimal mark (e.g., using \code{dec_mark = ","} with \code{0.152} would result in a formatted value of \verb{0,152}).}

\item{force_sign}{Should the positive sign be shown for positive values
(effectively showing a sign for all values except zero)? If so, use \code{TRUE}
for this option. The default is \code{FALSE}, where only negative numbers will
display a minus sign. This option is disregarded when using accounting
notation with \code{accounting = TRUE}.}

\item{incl_space}{An option for whether to include a space between the value
and the symbol/units. The default is \code{"auto"} which provides spacing
dependent on the mark itself. This can be directly controlled by using
either \code{TRUE} or \code{FALSE}.}

\item{system}{The numbering system to use. By default, this is the
international numbering system (\code{"intl"}) whereby grouping separators
(i.e., \code{sep_mark}) are separated by three digits. The alternative system,
the Indian numbering system (\code{"ind"}) uses grouping separators that
correspond to thousand, lakh, crore, and higher quantities.}

\item{locale}{An optional locale identifier that can be used for formatting
the value according the locale's rules. Examples include \code{"en"} for English
(United States) and \code{"fr"} for French (France). The use of a locale ID will
override any locale-specific values provided. We can use the
\code{\link[=info_locales]{info_locales()}} function as a useful reference for all of the locales that
are supported.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
With numeric values in a \strong{gt} table we can format the values so that they
are rendered as \emph{per mille}, \emph{ppm}, \emph{ppb}, etc., quantities. The following
list of keywords (with associated naming and scaling factors) is available to
use within \code{fmt_partsper()}:
\itemize{
\item \code{"per-mille"}: Per mille, (1 part in \verb{1,000})
\item \code{"per-myriad"}: Per myriad, (1 part in \verb{10,000})
\item \code{"pcm"}: Per cent mille (1 part in \verb{100,000})
\item \code{"ppm"}: Parts per million, (1 part in \verb{1,000,000})
\item \code{"ppb"}: Parts per billion, (1 part in \verb{1,000,000,000})
\item \code{"ppt"}: Parts per trillion, (1 part in \verb{1,000,000,000,000})
\item \code{"ppq"}: Parts per quadrillion, (1 part in \verb{1,000,000,000,000,000})
}

The function provides a lot of formatting control and we can use the
following options:
\itemize{
\item custom symbol/units: we can override the automatic symbol or units display
with our own choice as the situation warrants
\item decimals: choice of the number of decimal places, option to drop
trailing zeros, and a choice of the decimal symbol
\item digit grouping separators: options to enable/disable digit separators
and provide a choice of separator symbol
\item value scaling toggle: choose to disable automatic value scaling in the
situation that values are already scaled coming in (and just require the
appropriate symbol or unit display)
\item pattern: option to use a text pattern for decoration of the formatted
values
\item locale-based formatting: providing a locale ID will result in number
formatting specific to the chosen locale
}
}
\section{Compatibility of formatting function with data values}{


The \code{fmt_partsper()} formatting function is compatible with body cells that
are of the \code{"numeric"} or \code{"integer"} types. Any other types of body cells
are ignored during formatting. This is to say that cells of incompatible data
types may be targeted, but there will be no attempt to format them.
}

\section{Targeting cells with \code{columns} and \code{rows}}{


Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). The
\code{columns} argument allows us to target a subset of cells contained in the
resolved columns. We say resolved because aside from declaring column names
in \code{c()} (with bare column names or names in quotes) we can use
\strong{tidyselect}-style expressions. This can be as basic as supplying a select
helper like \code{starts_with()}, or, providing a more complex incantation like

\code{where(~ is.numeric(.x) && max(.x, na.rm = TRUE) > 1E6)}

which targets numeric columns that have a maximum value greater than
1,000,000 (excluding any \code{NA}s from consideration).

By default all columns and rows are selected (with the \code{everything()}
defaults). Cell values that are incompatible with a given formatting function
will be skipped over, like \code{character} values and numeric \verb{fmt_*()}
functions. So it's safe to select all columns with a particular formatting
function (only those values that can be formatted will be formatted), but,
you may not want that. One strategy is to format the bulk of cell values with
one formatting function and then constrain the columns for later passes with
other types of formatting (the last formatting done to a cell is what you get
in the final output).

Once the columns are targeted, we may also target the \code{rows} within those
columns. This can be done in a variety of ways. If a stub is present, then we
potentially have row identifiers. Those can be used much like column names in
the \code{columns}-targeting scenario. We can use simpler \strong{tidyselect}-style
expressions (the select helpers should work well here) and we can use quoted
row identifiers in \code{c()}. It's also possible to use row indices (e.g.,
\code{c(3, 5, 6)}) though these index values must correspond to the row numbers of
the input data (the indices won't necessarily match those of rearranged rows
if row groups are present). One more type of expression is possible, an
expression that takes column values (can involve any of the available columns
in the table) and returns a logical vector. This is nice if you want to base
formatting on values in the column or another column, or, you'd like to use a
more complex predicate expression.
}

\section{Adapting output to a specific \code{locale}}{


This formatting function can adapt outputs according to a provided \code{locale}
value. Examples include \code{"en"} for English (United States) and \code{"fr"} for
French (France). The use of a valid locale ID here means separator and
decimal marks will be correct for the given locale. Should any values be
provided in \code{sep_mark} or \code{dec_mark}, they will be overridden by the locale's
preferred values.

Note that a \code{locale} value provided here will override any global locale
setting performed in \code{\link[=gt]{gt()}}'s own \code{locale} argument (it is settable there as
a value received by all other functions that have a \code{locale} argument). As a
useful reference on which locales are supported, we can use the
\code{\link[=info_locales]{info_locales()}} function to view an info table.
}

\section{Examples}{


Create a tibble of small numeric values and generate a \strong{gt} table. Format
the \code{a} column to appear in scientific notation with \code{\link[=fmt_scientific]{fmt_scientific()}} and
format the \code{b} column as \emph{per mille} values with \code{fmt_partsper()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::tibble(x = 0:-5, a = 10^(0:-5), b = a) |>
  gt(rowname_col = "x") |>
  fmt_scientific(a, decimals = 0) |>
  fmt_partsper(
    columns = b,
    to_units = "per-mille"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_partsper_1.png" alt="This image of a table was generated from the first code example in the `fmt_partsper()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-6
}

\section{Function Introduced}{

\code{v0.6.0} (May 24, 2022)
}

\seealso{
The vector-formatting version of this function:
\code{\link[=vec_fmt_partsper]{vec_fmt_partsper()}}.

Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt_auto}()},
\code{\link{fmt_bins}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_flag}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_image}()},
\code{\link{fmt_index}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_spelled_num}()},
\code{\link{fmt_time}()},
\code{\link{fmt_url}()},
\code{\link{fmt}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()}
}
\concept{data formatting functions}
