% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_and_stack.R
\name{gt_merge_stack_color}
\alias{gt_merge_stack_color}
\title{Merge and stack text with background coloring from two columns in \code{gt}}
\usage{
gt_merge_stack_color(
  gt_object,
  top_val,
  color_val,
  palette = c("#512daa", "white", "#2d6a22"),
  domain = NULL,
  small_cap = TRUE,
  font_size = c("14px", "10px"),
  font_weight = c("bold", "bold")
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{top_val}{The column to stack on top. Will be converted to all caps, with bold text by default.}

\item{color_val}{The column to merge and place below, and controls the background color value. Will be smaller by default.}

\item{palette}{The colours or colour function that values will be mapped to, accepts a string or named palettes from paletteer.}

\item{domain}{The possible values that can be mapped. This can be a simple numeric range (e.g. \code{c(0, 100)}).}

\item{small_cap}{a logical indicating whether to use 'small-cap' on the top line of text, defaults to \code{TRUE}.}

\item{font_size}{a string of length 2 indicating the font-size in px of the top and bottom text}

\item{font_weight}{a string of length 2 indicating the 'font-weight' of the top and bottom text. Must be one of 'bold', 'normal', 'lighter'}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_merge_stack_color()} function takes an existing \code{gt} table and merges
column 1 and column 2, stacking column 1's text on top of column 2's.
This variant also accepts a palette argument to colorize the background
values.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{set.seed(12345)
 dplyr::tibble(
   value = sample(state.name, 5),
   color_by = seq.int(10, 98, length.out = 5)
 ) \%>\%
   gt::gt() \%>\%
   gt_merge_stack_color(value, color_by)
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{merge-stack-color.png}{options: width=50\%}}
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
