% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_gtfs.R
\name{filter_by_route_type}
\alias{filter_by_route_type}
\title{Filter GTFS data by transport mode  (route type)}
\usage{
filter_by_route_type(gtfs_data, route_types)
}
\arguments{
\item{gtfs_data}{A list of data.tables read using gtfs2gps::reag_gtfs().}

\item{route_types}{A vector of route types belonging to the routes of the
gtfs_data data. Note that route_type might be loaded by gtfs2gps::read_gtfs()
as a string or a number, depending on the available values.}
}
\value{
A filtered GTFS data.
}
\description{
Filter a GTFS data by transport mode (coded in the column route_type 
in routes.txt). It also removes the  unnecessary trips, stop_times, shapes, 
frequencies (if exist in a feed), and stops accordingly.
}
\examples{
warsaw <- read_gtfs(system.file("extdata/warsaw.zip", package="gtfs2gps"))

subset <- filter_by_route_type(warsaw, c(0, 3))
}
