% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent_key.R
\name{indent_key.fmt_uni_regression}
\alias{indent_key.fmt_uni_regression}
\title{Makes index of factor variables requiring indent from
\code{fmt_regression} objects in Rmarkdown}
\usage{
\method{indent_key}{fmt_uni_regression}(x, ...)
}
\arguments{
\item{x}{\code{fmt_regression} object}

\item{...}{further arguments passed to or from other methods}
}
\description{
Makes index of factor variables requiring indent from
\code{fmt_regression} objects in Rmarkdown
}
\examples{
\donttest{
  library(lme4)
  uni_mod <- fmt_uni_regression(trial,
    method = "glm",
    y = "response",
    method.args = list(family = binomial),
    exponentiate = TRUE
  )

  # In RMarkdown, knitting to HTML:
  kable(as_tibble(uni_mod),
    row.names = FALSE,
    caption = "Model Summary"
  ) \%>\%
    kableExtra::add_indent(indent_key(uni_mod))
}

}
