% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_global_p.R
\name{add_global_p.tbl_uvregression}
\alias{add_global_p.tbl_uvregression}
\title{Adds the global p-value for categorical variables}
\usage{
\method{add_global_p}{tbl_uvregression}(x, ...)
}
\arguments{
\item{x}{Object with class \code{tbl_uvregression} from the
\link{tbl_uvregression} function}

\item{...}{Additional arguments to be passed to \link[car:Anova]{car::Anova}.}
}
\value{
A \code{tbl_uvregression} object
}
\description{
This function uses \link[car:Anova]{car::Anova} with argument
\code{type = "III"} to calculate global p-values for categorical variables.
}
\section{Example Output}{

\if{html}{\figure{tbl_uv_global_ex2.png}{options: width=50\%}}
}

\examples{
tbl_uv_global_ex2 <-
  trial[c("response", "trt", "age", "grade")] \%>\%
  tbl_uvregression(
    method = glm,
    y = response,
    method.args = list(family = binomial),
    exponentiate = TRUE
  ) \%>\%
  add_global_p()
}
\seealso{
Other tbl_uvregression tools: 
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{modify_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_uvregression}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_uvregression tools}
