% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_spanning_header.R
\name{modify_spanning_header}
\alias{modify_spanning_header}
\title{Update gtsummary table spanning header}
\usage{
modify_spanning_header(x, update)
}
\arguments{
\item{x}{a gtsummary object}

\item{update}{list of formulas or a single formula specifying the update.
The LHS selects the variables
whose spanning header will be updated, and the RHS is the new spanning header.
For example, \code{update = starts_with("stat_") ~ "New spanning header!"}.
Columns from \code{x$table_body} may be selected.
To remove all spanning headers, use \code{update = everything() ~ NA}.}
}
\value{
gtsummary object
}
\description{
Update gtsummary table spanning header
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{spanning_header_ex1.png}{options: width=70\%}}
}

\examples{
# Example 1 ----------------------------------
# add header above summary statistics
spanning_header_ex1 <-
  trial \%>\%
  select(trt, age, grade) \%>\%
  tbl_summary(by = trt) \%>\%
  modify_spanning_header(starts_with("stat_") ~ "**Randomization Assignment**")
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{modify_footnote}()},
\code{\link{modify_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}

Other tbl_regression tools: 
\code{\link{add_global_p.tbl_regression}()},
\code{\link{add_nevent.tbl_regression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{combine_terms}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify_footnote}()},
\code{\link{modify_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_stack}()}

Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{modify_footnote}()},
\code{\link{modify_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_uvregression}()}
}
\concept{tbl_regression tools}
\concept{tbl_summary tools}
\concept{tbl_uvregression tools}
