% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.R
\name{inline_text.tbl_cross}
\alias{inline_text.tbl_cross}
\title{Report statistics from cross table inline}
\usage{
\method{inline_text}{tbl_cross}(x, col_level = NULL, row_level = NULL, pvalue_fun = NULL, ...)
}
\arguments{
\item{x}{a \code{tbl_cross} object}

\item{col_level}{Level of the column variable to display. Default is \code{NULL}
Can also specify "\code{p.value}" for the p-value and "\code{stat_0}" for Total column.}

\item{row_level}{Level of the row variable to display.
Can also specify the 'Unknown' row. Default is \code{NULL}}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{...}{Not used}
}
\value{
A string reporting results from a gtsummary table
}
\description{
\lifecycle{maturing}
Extracts and returns statistics from a \code{tbl_cross} object for
inline reporting in an R markdown document. Detailed examples in the
\href{http://www.danieldsjoberg.com/gtsummary/articles/inline_text.html}{inline_text vignette}
}
\examples{
tbl_cross <-
  tbl_cross(trial, row = trt, col = response) \%>\%
  add_p()

inline_text(tbl_cross, row_level = "Drug A", col_level = "1")
inline_text(tbl_cross, row_level = "Total", col_level = "1")
inline_text(tbl_cross, col_level = "p.value")
}
\seealso{
Other tbl_cross tools: 
\code{\link{add_p.tbl_cross}()},
\code{\link{tbl_cross}()}
}
\concept{tbl_cross tools}
