% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax.R
\name{syntax}
\alias{syntax}
\title{Syntax and Notation}
\description{
The gtsummary package also utilizes selectors: selectors from the tidyselect
package and custom selectors. Review their help files for details.
\itemize{
\item \strong{tidy selectors}

\code{everything()}, \code{all_of()}, \code{any_of()}, \code{starts_with()}, \code{ends_with()},
\code{contains()}, \code{matches()}, \code{num_range()}, \code{last_col()}
\item \strong{gtsummary selectors}

\code{all_continuous()}, \code{all_categorical()}, \code{all_dichotomous()},
\code{all_continuous2()}, \code{all_tests()}, \code{all_stat_cols()},
\code{all_interaction()}, \code{all_intercepts()}, \code{all_contrasts()}
}

Many arguments throughout the gtsummary package accept list and
formula notation, e.g. \code{tbl_summary(statistic=)}. Below enumerates a few
tips and shortcuts for using the list and formulas.
\enumerate{
\item \strong{List of Formulas}

Typical usage includes a list of formulas, where the LHS is a variable
name or a selector.\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_summary(statistic = list(age ~ "\{mean\}", all_categorical() ~ "\{n\}"))
}\if{html}{\out{</div>}}
\item \strong{Named List}

You may also pass a named list; however, the tidyselect and gtsummary selectors
are not supported with this syntax.\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_summary(statistic = list(age = "\{mean\}", response = "\{n\}"))
}\if{html}{\out{</div>}}
\item \strong{Hybrid Named List/List of Formulas}

Pass a combination of formulas and named elements\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_summary(statistic = list(age = "\{mean\}", all_categorical() ~ "\{n\}"))
}\if{html}{\out{</div>}}
\item \strong{Shortcuts}

You can pass a single formula, which is equivalent to passing the formula
in a list.\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_summary(statistic = all_categorical() ~ "\{n\}")
}\if{html}{\out{</div>}}

As a shortcut to select all variables, you can omit the LHS of the formula.
The two calls below are equivalent.\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_summary(statistic = ~"\{n\}")
tbl_summary(statistic = everything() ~ "\{n\}")
}\if{html}{\out{</div>}}
\item \strong{Combination Selectors}

Selectors can be combined using the \code{c()} function.\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_summary(statistic = c(everything(), -grade) ~ "\{n\}")
}\if{html}{\out{</div>}}
}
}
