% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_strata.R
\name{tbl_strata}
\alias{tbl_strata}
\alias{tbl_strata2}
\title{Stratified gtsummary tables}
\usage{
tbl_strata(
  data,
  strata,
  .tbl_fun,
  ...,
  .sep = ", ",
  .combine_with = c("tbl_merge", "tbl_stack"),
  .combine_args = NULL,
  .header = ifelse(.combine_with == "tbl_merge", "**{strata}**", "{strata}"),
  .quiet = NULL
)

tbl_strata2(
  data,
  strata,
  .tbl_fun,
  ...,
  .sep = ", ",
  .combine_with = c("tbl_merge", "tbl_stack"),
  .combine_args = NULL,
  .header = ifelse(.combine_with == "tbl_merge", "**{strata}**", "{strata}"),
  .quiet = TRUE
)
}
\arguments{
\item{data}{(\code{data.frame}, \code{survey.design})\cr
a data frame or survey object}

\item{strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
character vector or tidy-selector of columns in data to stratify results by.
Only \emph{observed} combinations are shown in results.}

\item{.tbl_fun}{(\code{function})
A function or formula. If a \emph{function}, it is used as is.
If a formula, e.g. \code{~ .x \%>\% tbl_summary() \%>\% add_p()}, it is converted to a function.
The stratified data frame is passed to this function.}

\item{...}{Additional arguments passed on to the \code{.tbl_fun} function.}

\item{.sep}{(\code{string})\cr
when more than one stratifying variable is passed, this string is
used to separate the levels in the spanning header. Default is \code{", "}}

\item{.combine_with}{(\code{string})\cr
One of \code{c("tbl_merge", "tbl_stack")}. Names the function
used to combine the stratified tables.}

\item{.combine_args}{(named \code{list})\cr
named list of arguments that are passed to function specified in \code{.combine_with}}

\item{.header}{(\code{string})\cr
String indicating the headers that will be placed.
Default is \code{"**{strata}**"} when \code{.combine_with = "tbl_merge"} and
\code{"{strata}"} when \code{.combine_with = "tbl_stack"}. Items placed in
curly brackets will be evaluated according to \code{glue::glue()} syntax.
- \code{strata} stratum levels
- \code{n} N within stratum
- \code{N} Overall N

The evaluated value of \code{.header} is also available within \code{tbl_strata2(.tbl_fun)}}

\item{.quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
Build a stratified gtsummary table. Any gtsummary table that accepts
a data frame as its first argument can be stratified.
\itemize{
\item In \code{tbl_strata()}, the stratified or subset data frame is passed to the
function in \verb{.tbl_fun=}, e.g. \code{purrr::map(data, .tbl_fun)}.
\item In \code{tbl_strata2()}, both the stratified data frame and the strata level
are passed to \verb{.tbl_fun=}, e.g. \code{purrr::map2(data, strata, .tbl_fun)}.
}

When merging, keep in mind that merging works best with \strong{like tables}.
See \code{\link[=tbl_merge]{tbl_merge()}} for details.
}
\section{Tips}{

\itemize{
\item \code{tbl_summary()}
\itemize{
\item The number of digits continuous variables are rounded to is determined
separately within each stratum of the data frame. Set the \verb{digits=}
argument to ensure continuous variables are rounded to the same number
of decimal places.
\item If some levels of a categorical variable are unobserved within a
stratum, convert the variable to a factor to ensure all levels appear in
each stratum's summary table.
\item The summary type for variables (e.g. continuous vs categorical vs dichotomous)
are determined separately within stratum. Use the \code{tbl_summary(type)}
argument to assign a summary type consistent across all tables being combined.
\item By default, a "missing" row appears when there are missing values only.
Use the \code{tbl_summary(missing)} argument to ensure there is always/never
a missing row for the combining of the tables.
}
}
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("cardx", "broom"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
trial |>
  select(age, grade, stage, trt) |>
  mutate(grade = paste("Grade", grade)) |>
  tbl_strata(
    strata = grade,
    .tbl_fun =
      ~ .x |>
        tbl_summary(by = trt, missing = "no") |>
        add_n(),
    .header = "**{strata}**, N = {n}"
  )

# Example 2 ----------------------------------
trial |>
  select(grade, response) |>
  mutate(grade = paste("Grade", grade)) |>
  tbl_strata2(
    strata = grade,
    .tbl_fun =
      ~ .x \%>\%
        tbl_summary(
          label = list(response = .y),
          missing = "no",
          statistic = response ~ "{p}\%"
        ) |>
        add_ci(pattern = "{stat} ({ci})") |>
        modify_header(stat_0 = "**Rate (95\% CI)**") |>
        remove_footnote_header(stat_0),
    .combine_with = "tbl_stack",
    .combine_args = list(group_header = NULL)
  ) |>
  modify_caption("**Response Rate by Grade**")
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
