% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{metadata_lst}
\alias{metadata_lst}
\title{Generate a list to hold GWAS metadata}
\usage{
metadata_lst(
  ensembl_release_number = NA_integer_,
  genome_build_version = NA_character_,
  dbsnp_version = NA_integer_,
  usage_start_date = lubridate::ymd_hms()
)
}
\arguments{
\item{ensembl_release_number}{\href{https://www.ensembl.org/info/docs/api/versions.html}{Ensembl release
number}.}

\item{genome_build_version}{\href{https://www.ncbi.nlm.nih.gov/grc/human}{Genome build version}.}

\item{dbsnp_version}{\href{https://www.ncbi.nlm.nih.gov/projects/SNP/snp_summary.cgi}{dbSNP
version}.}

\item{usage_start_date}{Date since this combination of resource versions has
been in use.}
}
\value{
A list of 4 named elements as passed as arguments:
  \code{ensembl_release_number}, \code{genome_build_version},
  \code{dbsnp_version} and \code{usage_start_date}.
}
\description{
Creates a list to hold GWAS Catalog metadata.
}
\keyword{internal}
