% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwer.montecarlo.R
\name{gwer.montecarlo}
\alias{gwer.montecarlo}
\title{Monte Carlo (randomisation) Test for Significance of GWER Parameter Variability}
\usage{
gwer.montecarlo(
  formula,
  family = Normal,
  data = list(),
  nsims = 99,
  kernel = "bisquare",
  adaptive = F,
  bw,
  p = 2,
  theta = 0,
  dispersion = NULL,
  longlat = F,
  dMat,
  control = glm.control(epsilon = 1e-04, maxit = 100, trace = F)
)
}
\arguments{
\item{formula}{regression model formula of a formula \code{object}.}

\item{family}{a description of the error distribution to be used in the model (see \code{\link{family.elliptical}} for details of elliptical distribution).}

\item{data}{an optional data frame, list or environment containing the variables in the model.}

\item{nsims}{the number of randomisations.}

\item{kernel}{function chosen as follows:
gaussian: wgt = exp(-.5*(vdist/bw)^2);
exponential: wgt = exp(-vdist/bw);
bisquare: wgt = (1-(vdist/bw)^2)^2 if vdist < bw, wgt=0 otherwise;
tricube: wgt = (1-(vdist/bw)^3)^3 if vdist < bw, wgt=0 otherwise;
boxcar: wgt=1 if dist < bw, wgt=0 otherwise.}

\item{adaptive}{if TRUE calculate an adaptive kernel where the bandwidth (bw) corresponds to the number of nearest neighbours (i.e. adaptive distance); default is FALSE, where a fixed kernel is found (bandwidth is a fixed distance).}

\item{bw}{value of the selected bandwidth used in the weighting function (see \code{\link{bw.gwer}} for bandwidth optimization).}

\item{p}{the power of the Minkowski distance, default is 2 (Euclidean distance).}

\item{theta}{an angle in radians to rotate the coordinate system, default is 0}

\item{dispersion}{an optional fixed value for dispersion parameter.}

\item{longlat}{if TRUE, great circle distances will be calculated.}

\item{dMat}{a pre-specified distance matrix, it can be calculated by the function \code{\link{gw.dist}}.}

\item{control}{a list of parameters for controlling the fitting process. This is passed by \code{\link{glm.control}}.}
}
\value{
A vector containing p-values for all parameters spatial variability tests
}
\description{
This function implements a Monte Carlo (randomisation) test to test for significant (spatial) variability of a geographically weighted elliptical regression model's parameters or coefficients.
}
\examples{
\donttest{
data(georgia, package = "spgwr")
fit.formula <- PctBach ~ TotPop90 + PctRural + PctFB + PctPov
gwer.bw.t <- bw.gwer(fit.formula, data = gSRDF, family = Student(4), adapt = TRUE)
gwer.fit.t <- gwer(fit.formula, data = gSRDF, family = Student(4), bandwidth = gwer.bw.t, 
                   adapt = TRUE, parplot = FALSE, hatmatrix = TRUE, spdisp = TRUE, 
                   method = "gwer.fit")
gwer.montecarlo(fit.formula, data = gSRDF, family = Student(3), bw = gwer.bw.t, adaptive = TRUE) 
}
}
\references{
Brunsdon C, Fotheringham AS, Charlton ME (1998) Geographically weighted regression - modelling spatial non-stationarity. Journal of the Royal
Statistical Society, Series D-The Statistician 47(3):431-443
}
\seealso{
\code{\link{bw.gwer}}, \code{\link{elliptical}}, \code{\link{family.elliptical}}
}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{Parameter}
\keyword{Tests}
\keyword{Variability}
\keyword{model}
\keyword{regression}
\keyword{weighted}
