% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdelaunay.R
\encoding{UTF-8}
\name{hdelaunay}
\alias{hdelaunay}
\title{Hyperbolic Delaunay triangulation}
\usage{
hdelaunay(points, model = "M")
}
\arguments{
\item{points}{points in the unit disk given as a numeric matrix with
two columns}

\item{model}{the hyperbolic model, either \code{"M"} (Möbius model, i.e.
Poincaré model) or \code{"U"} (Ungar model, i.e. hyperboloid model)}
}
\value{
A list with five fields \code{vertices}, \code{edges},
  \code{triangles}, \code{ntriangles}, and \code{centroids}, a matrix
  giving the gyrocentroids of the triangles.
  The input \code{points} matrix and the output \code{vertices} matrix
  are the same up to the order of the rows if \code{model="M"}, and if
  \code{model="U"}, the points in the output \code{vertices} matrix are
  obtained by isomorphism.
}
\description{
Computes the hyperbolic Delaunay triangulation of a set of
  points.
}
\examples{
library(gyro)
library(uniformly)
set.seed(666)
points <- runif_in_sphere(10L, d = 2)
hdelaunay(points)
}
\seealso{
\code{\link{plotHdelaunay}}
}
