% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgboost.R
\name{h2o.xgboost}
\alias{h2o.xgboost}
\title{Build an eXtreme Gradient Boosting model}
\usage{
h2o.xgboost(x, y, training_frame, model_id = NULL, validation_frame = NULL,
  nfolds = 0, keep_cross_validation_predictions = FALSE,
  keep_cross_validation_fold_assignment = FALSE,
  score_each_iteration = FALSE, fold_assignment = c("AUTO", "Random",
  "Modulo", "Stratified"), fold_column = NULL, ignore_const_cols = TRUE,
  offset_column = NULL, weights_column = NULL, stopping_rounds = 0,
  stopping_metric = c("AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE",
  "RMSLE", "AUC", "lift_top_group", "misclassification",
  "mean_per_class_error"), stopping_tolerance = 0.001, max_runtime_secs = 0,
  seed = -1, distribution = c("AUTO", "bernoulli", "multinomial",
  "gaussian", "poisson", "gamma", "tweedie", "laplace", "quantile", "huber"),
  tweedie_power = 1.5, categorical_encoding = c("AUTO", "Enum",
  "OneHotInternal", "OneHotExplicit", "Binary", "Eigen", "LabelEncoder",
  "SortByResponse", "EnumLimited"), quiet_mode = TRUE, ntrees = 50,
  max_depth = 6, min_rows = 1, min_child_weight = 1, learn_rate = 0.3,
  eta = 0.3, sample_rate = 1, subsample = 1, col_sample_rate = 1,
  colsample_bylevel = 1, col_sample_rate_per_tree = 1,
  colsample_bytree = 1, max_abs_leafnode_pred = 0, max_delta_step = 0,
  score_tree_interval = 0, min_split_improvement = 0, gamma = 0,
  nthread = -1, max_bins = 256, max_leaves = 0,
  min_sum_hessian_in_leaf = 100, min_data_in_leaf = 0,
  sample_type = c("uniform", "weighted"), normalize_type = c("tree",
  "forest"), rate_drop = 0, one_drop = FALSE, skip_drop = 0,
  tree_method = c("auto", "exact", "approx", "hist"),
  grow_policy = c("depthwise", "lossguide"), booster = c("gbtree",
  "gblinear", "dart"), reg_lambda = 0, reg_alpha = 0,
  dmatrix_type = c("auto", "dense", "sparse"), backend = c("auto", "gpu",
  "cpu"), gpu_id = 0, verbose = FALSE)
}
\arguments{
\item{x}{(Optional) A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing, then all columns except y are used.}

\item{y}{The name or column index of the response variable in the data. The response must be either a numeric or a
categorical/factor variable. If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.}

\item{training_frame}{Id of the training data frame.}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{validation_frame}{Id of the validation data frame.}

\item{nfolds}{Number of folds for K-fold cross-validation (0 to disable or >= 2). Defaults to 0.}

\item{keep_cross_validation_predictions}{\code{Logical}. Whether to keep the predictions of the cross-validation models. Defaults to FALSE.}

\item{keep_cross_validation_fold_assignment}{\code{Logical}. Whether to keep the cross-validation fold assignment. Defaults to FALSE.}

\item{score_each_iteration}{\code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will
stratify the folds based on the response variable, for classification problems. Must be one of: "AUTO",
"Random", "Modulo", "Stratified". Defaults to AUTO.}

\item{fold_column}{Column with cross-validation fold index assignment per observation.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{offset_column}{Offset column. This will be added to the combination of columns before applying the link function.}

\item{weights_column}{Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
well. During training, rows with higher weights matter more, due to the larger loss function pre-factor.}

\item{stopping_rounds}{Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) Defaults to 0.}

\item{stopping_metric}{Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) Must be one of:
"AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC", "lift_top_group", "misclassification",
"mean_per_class_error". Defaults to AUTO.}

\item{stopping_tolerance}{Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this
much) Defaults to 0.001.}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default)
Defaults to -1 (time-based random number).}

\item{distribution}{Distribution function Must be one of: "AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma",
"tweedie", "laplace", "quantile", "huber". Defaults to AUTO.}

\item{tweedie_power}{Tweedie power for Tweedie regression, must be between 1 and 2. Defaults to 1.5.}

\item{categorical_encoding}{Encoding scheme for categorical features Must be one of: "AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
"Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited". Defaults to AUTO.}

\item{quiet_mode}{\code{Logical}. Enable quiet mode Defaults to TRUE.}

\item{ntrees}{(same as n_estimators) Number of trees. Defaults to 50.}

\item{max_depth}{Maximum tree depth. Defaults to 6.}

\item{min_rows}{(same as min_child_weight) Fewest allowed (weighted) observations in a leaf. Defaults to 1.}

\item{min_child_weight}{(same as min_rows) Fewest allowed (weighted) observations in a leaf. Defaults to 1.}

\item{learn_rate}{(same as eta) Learning rate (from 0.0 to 1.0) Defaults to 0.3.}

\item{eta}{(same as learn_rate) Learning rate (from 0.0 to 1.0) Defaults to 0.3.}

\item{sample_rate}{(same as subsample) Row sample rate per tree (from 0.0 to 1.0) Defaults to 1.}

\item{subsample}{(same as sample_rate) Row sample rate per tree (from 0.0 to 1.0) Defaults to 1.}

\item{col_sample_rate}{(same as colsample_bylevel) Column sample rate (from 0.0 to 1.0) Defaults to 1.}

\item{colsample_bylevel}{(same as col_sample_rate) Column sample rate (from 0.0 to 1.0) Defaults to 1.}

\item{col_sample_rate_per_tree}{(same as colsample_bytree) Column sample rate per tree (from 0.0 to 1.0) Defaults to 1.}

\item{colsample_bytree}{(same as col_sample_rate_per_tree) Column sample rate per tree (from 0.0 to 1.0) Defaults to 1.}

\item{max_abs_leafnode_pred}{(same as max_delta_step) Maximum absolute value of a leaf node prediction Defaults to 0.0.}

\item{max_delta_step}{(same as max_abs_leafnode_pred) Maximum absolute value of a leaf node prediction Defaults to 0.0.}

\item{score_tree_interval}{Score the model after every so many trees. Disabled if set to 0. Defaults to 0.}

\item{min_split_improvement}{(same as gamma) Minimum relative improvement in squared error reduction for a split to happen Defaults to 0.0.}

\item{gamma}{(same as min_split_improvement) Minimum relative improvement in squared error reduction for a split to happen
Defaults to 0.0.}

\item{nthread}{Number of parallel threads that can be used to run XGBoost. Cannot exceed H2O cluster limits (-nthreads
parameter). Defaults to maximum available Defaults to -1.}

\item{max_bins}{For tree_method=hist only: maximum number of bins Defaults to 256.}

\item{max_leaves}{For tree_method=hist only: maximum number of leaves Defaults to 0.}

\item{min_sum_hessian_in_leaf}{For tree_method=hist only: the mininum sum of hessian in a leaf to keep splitting Defaults to 100.0.}

\item{min_data_in_leaf}{For tree_method=hist only: the mininum data in a leaf to keep splitting Defaults to 0.0.}

\item{sample_type}{For booster=dart only: sample_type Must be one of: "uniform", "weighted". Defaults to uniform.}

\item{normalize_type}{For booster=dart only: normalize_type Must be one of: "tree", "forest". Defaults to tree.}

\item{rate_drop}{For booster=dart only: rate_drop (0..1) Defaults to 0.0.}

\item{one_drop}{\code{Logical}. For booster=dart only: one_drop Defaults to FALSE.}

\item{skip_drop}{For booster=dart only: skip_drop (0..1) Defaults to 0.0.}

\item{tree_method}{Tree method Must be one of: "auto", "exact", "approx", "hist". Defaults to auto.}

\item{grow_policy}{Grow policy - depthwise is standard GBM, lossguide is LightGBM Must be one of: "depthwise", "lossguide".
Defaults to depthwise.}

\item{booster}{Booster type Must be one of: "gbtree", "gblinear", "dart". Defaults to gbtree.}

\item{reg_lambda}{L2 regularization Defaults to 0.0.}

\item{reg_alpha}{L1 regularization Defaults to 0.0.}

\item{dmatrix_type}{Type of DMatrix. For sparse, NAs and 0 are treated equally. Must be one of: "auto", "dense", "sparse".
Defaults to auto.}

\item{backend}{Backend. By default (auto), a GPU is used if available. Must be one of: "auto", "gpu", "cpu". Defaults to
auto.}

\item{gpu_id}{Which GPU to use.  Defaults to 0.}

\item{verbose}{\code{Logical}. Print scoring history to the console (Metrics per tree for GBM, DRF, & XGBoost. Metrics per epoch for Deep Learning). Defaults to FALSE.}
}
\description{
Builds a eXtreme Gradient Boosting model using the native XGBoost backend.
}
