/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_bandit4arm_lapse_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_bandit4arm_lapse");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_bandit4arm_lapse");
    reader.add_event(196, 181, "end", "model_bandit4arm_lapse");
    return reader;
}

#include <meta_header.hpp>
 class model_bandit4arm_lapse : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > rew;
    vector<vector<double> > los;
    vector<vector<int> > choice;
    vector_d initV;
public:
    model_bandit4arm_lapse(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_bandit4arm_lapse(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_bandit4arm_lapse_namespace::model_bandit4arm_lapse";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 20;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("rew", "N", N);
            validate_non_negative_index("rew", "T", T);
            context__.validate_dims("data initialization", "rew", "double", context__.to_vec(N,T));
            validate_non_negative_index("rew", "N", N);
            validate_non_negative_index("rew", "T", T);
            rew = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("rew");
            pos__ = 0;
            size_t rew_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < rew_limit_1__; ++i_1__) {
                size_t rew_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < rew_limit_0__; ++i_0__) {
                    rew[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("los", "N", N);
            validate_non_negative_index("los", "T", T);
            context__.validate_dims("data initialization", "los", "double", context__.to_vec(N,T));
            validate_non_negative_index("los", "N", N);
            validate_non_negative_index("los", "T", T);
            los = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("los");
            pos__ = 0;
            size_t los_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < los_limit_1__; ++i_1__) {
                size_t los_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < los_limit_0__; ++i_0__) {
                    los[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("choice");
            pos__ = 0;
            size_t choice_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
                size_t choice_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                    choice[i_0__][i_1__] = vals_i__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 19;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 20;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 21;
            current_statement_begin__ = 22;
            current_statement_begin__ = 23;
            // initialize data variables
            current_statement_begin__ = 27;
            validate_non_negative_index("initV", "4", 4);
            initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
            stan::math::fill(initV,DUMMY_VAR__);

            current_statement_begin__ = 28;
            stan::math::assign(initV, rep_vector(0.0,4));

            // validate transformed data
            current_statement_begin__ = 27;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 34;
            validate_non_negative_index("mu_pr", "5", 5);
            num_params_r__ += 5;
            current_statement_begin__ = 35;
            validate_non_negative_index("sigma", "5", 5);
            num_params_r__ += 5;
            current_statement_begin__ = 38;
            validate_non_negative_index("Arew_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 39;
            validate_non_negative_index("Apun_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 40;
            validate_non_negative_index("R_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 41;
            validate_non_negative_index("P_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 42;
            validate_non_negative_index("xi_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_bandit4arm_lapse() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "5", 5);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(5));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(5));
        for (int j1__ = 0U; j1__ < 5; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "5", 5);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(5));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(5));
        for (int j1__ = 0U; j1__ < 5; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("Arew_pr")))
            throw std::runtime_error("variable Arew_pr missing");
        vals_r__ = context__.vals_r("Arew_pr");
        pos__ = 0U;
        validate_non_negative_index("Arew_pr", "N", N);
        context__.validate_dims("initialization", "Arew_pr", "vector_d", context__.to_vec(N));
        vector_d Arew_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            Arew_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(Arew_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable Arew_pr: ") + e.what());
        }

        if (!(context__.contains_r("Apun_pr")))
            throw std::runtime_error("variable Apun_pr missing");
        vals_r__ = context__.vals_r("Apun_pr");
        pos__ = 0U;
        validate_non_negative_index("Apun_pr", "N", N);
        context__.validate_dims("initialization", "Apun_pr", "vector_d", context__.to_vec(N));
        vector_d Apun_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            Apun_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(Apun_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable Apun_pr: ") + e.what());
        }

        if (!(context__.contains_r("R_pr")))
            throw std::runtime_error("variable R_pr missing");
        vals_r__ = context__.vals_r("R_pr");
        pos__ = 0U;
        validate_non_negative_index("R_pr", "N", N);
        context__.validate_dims("initialization", "R_pr", "vector_d", context__.to_vec(N));
        vector_d R_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            R_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(R_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable R_pr: ") + e.what());
        }

        if (!(context__.contains_r("P_pr")))
            throw std::runtime_error("variable P_pr missing");
        vals_r__ = context__.vals_r("P_pr");
        pos__ = 0U;
        validate_non_negative_index("P_pr", "N", N);
        context__.validate_dims("initialization", "P_pr", "vector_d", context__.to_vec(N));
        vector_d P_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            P_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(P_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable P_pr: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        validate_non_negative_index("xi_pr", "N", N);
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(5,lp__);
            else
                mu_pr = in__.vector_constrain(5);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,5,lp__);
            else
                sigma = in__.vector_lb_constrain(0,5);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Arew_pr;
            (void) Arew_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                Arew_pr = in__.vector_constrain(N,lp__);
            else
                Arew_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Apun_pr;
            (void) Apun_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                Apun_pr = in__.vector_constrain(N,lp__);
            else
                Apun_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  R_pr;
            (void) R_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                R_pr = in__.vector_constrain(N,lp__);
            else
                R_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  P_pr;
            (void) P_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                P_pr = in__.vector_constrain(N,lp__);
            else
                P_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  xi_pr;
            (void) xi_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                xi_pr = in__.vector_constrain(N,lp__);
            else
                xi_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 47;
            validate_non_negative_index("Arew", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Arew(static_cast<Eigen::VectorXd::Index>(N));
            (void) Arew;  // dummy to suppress unused var warning

            stan::math::initialize(Arew, DUMMY_VAR__);
            stan::math::fill(Arew,DUMMY_VAR__);
            current_statement_begin__ = 48;
            validate_non_negative_index("Apun", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Apun(static_cast<Eigen::VectorXd::Index>(N));
            (void) Apun;  // dummy to suppress unused var warning

            stan::math::initialize(Apun, DUMMY_VAR__);
            stan::math::fill(Apun,DUMMY_VAR__);
            current_statement_begin__ = 49;
            validate_non_negative_index("R", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  R(static_cast<Eigen::VectorXd::Index>(N));
            (void) R;  // dummy to suppress unused var warning

            stan::math::initialize(R, DUMMY_VAR__);
            stan::math::fill(R,DUMMY_VAR__);
            current_statement_begin__ = 50;
            validate_non_negative_index("P", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  P(static_cast<Eigen::VectorXd::Index>(N));
            (void) P;  // dummy to suppress unused var warning

            stan::math::initialize(P, DUMMY_VAR__);
            stan::math::fill(P,DUMMY_VAR__);
            current_statement_begin__ = 51;
            validate_non_negative_index("xi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
            (void) xi;  // dummy to suppress unused var warning

            stan::math::initialize(xi, DUMMY_VAR__);
            stan::math::fill(xi,DUMMY_VAR__);


            current_statement_begin__ = 53;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 54;
                stan::model::assign(Arew, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(Arew_pr,i,"Arew_pr",1)))), 
                            "assigning variable Arew");
                current_statement_begin__ = 55;
                stan::model::assign(Apun, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(Apun_pr,i,"Apun_pr",1)))), 
                            "assigning variable Apun");
                current_statement_begin__ = 56;
                stan::model::assign(R, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(R_pr,i,"R_pr",1)))) * 30), 
                            "assigning variable R");
                current_statement_begin__ = 57;
                stan::model::assign(P, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,4,"mu_pr",1) + (get_base1(sigma,4,"sigma",1) * get_base1(P_pr,i,"P_pr",1)))) * 30), 
                            "assigning variable P");
                current_statement_begin__ = 58;
                stan::model::assign(xi, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,5,"mu_pr",1) + (get_base1(sigma,5,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))), 
                            "assigning variable xi");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(Arew(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: Arew" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(Apun(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: Apun" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(R(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: R" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(P(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: P" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(xi(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 47;
            check_greater_or_equal(function__,"Arew",Arew,0);
            check_less_or_equal(function__,"Arew",Arew,1);
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"Apun",Apun,0);
            check_less_or_equal(function__,"Apun",Apun,1);
            current_statement_begin__ = 49;
            check_greater_or_equal(function__,"R",R,0);
            check_less_or_equal(function__,"R",R,30);
            current_statement_begin__ = 50;
            check_greater_or_equal(function__,"P",P,0);
            check_less_or_equal(function__,"P",P,30);
            current_statement_begin__ = 51;
            check_greater_or_equal(function__,"xi",xi,0);
            check_less_or_equal(function__,"xi",xi,1);

            // model body

            current_statement_begin__ = 64;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 65;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 68;
            lp_accum__.add(normal_log<propto__>(Arew_pr, 0, 1.0));
            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(Apun_pr, 0, 1.0));
            current_statement_begin__ = 70;
            lp_accum__.add(normal_log<propto__>(R_pr, 0, 1.0));
            current_statement_begin__ = 71;
            lp_accum__.add(normal_log<propto__>(P_pr, 0, 1.0));
            current_statement_begin__ = 72;
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            current_statement_begin__ = 74;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 76;
                validate_non_negative_index("Qr", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Qr(static_cast<Eigen::VectorXd::Index>(4));
                (void) Qr;  // dummy to suppress unused var warning

                stan::math::initialize(Qr, DUMMY_VAR__);
                stan::math::fill(Qr,DUMMY_VAR__);
                current_statement_begin__ = 77;
                validate_non_negative_index("Qp", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Qp(static_cast<Eigen::VectorXd::Index>(4));
                (void) Qp;  // dummy to suppress unused var warning

                stan::math::initialize(Qp, DUMMY_VAR__);
                stan::math::fill(Qp,DUMMY_VAR__);
                current_statement_begin__ = 78;
                validate_non_negative_index("PEr_fic", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  PEr_fic(static_cast<Eigen::VectorXd::Index>(4));
                (void) PEr_fic;  // dummy to suppress unused var warning

                stan::math::initialize(PEr_fic, DUMMY_VAR__);
                stan::math::fill(PEr_fic,DUMMY_VAR__);
                current_statement_begin__ = 79;
                validate_non_negative_index("PEp_fic", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  PEp_fic(static_cast<Eigen::VectorXd::Index>(4));
                (void) PEp_fic;  // dummy to suppress unused var warning

                stan::math::initialize(PEp_fic, DUMMY_VAR__);
                stan::math::fill(PEp_fic,DUMMY_VAR__);
                current_statement_begin__ = 80;
                validate_non_negative_index("Qsum", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Qsum(static_cast<Eigen::VectorXd::Index>(4));
                (void) Qsum;  // dummy to suppress unused var warning

                stan::math::initialize(Qsum, DUMMY_VAR__);
                stan::math::fill(Qsum,DUMMY_VAR__);
                current_statement_begin__ = 82;
                local_scalar_t__ Qr_chosen;
                (void) Qr_chosen;  // dummy to suppress unused var warning

                stan::math::initialize(Qr_chosen, DUMMY_VAR__);
                stan::math::fill(Qr_chosen,DUMMY_VAR__);
                current_statement_begin__ = 83;
                local_scalar_t__ Qp_chosen;
                (void) Qp_chosen;  // dummy to suppress unused var warning

                stan::math::initialize(Qp_chosen, DUMMY_VAR__);
                stan::math::fill(Qp_chosen,DUMMY_VAR__);
                current_statement_begin__ = 84;
                local_scalar_t__ PEr;
                (void) PEr;  // dummy to suppress unused var warning

                stan::math::initialize(PEr, DUMMY_VAR__);
                stan::math::fill(PEr,DUMMY_VAR__);
                current_statement_begin__ = 85;
                local_scalar_t__ PEp;
                (void) PEp;  // dummy to suppress unused var warning

                stan::math::initialize(PEp, DUMMY_VAR__);
                stan::math::fill(PEp,DUMMY_VAR__);


                current_statement_begin__ = 88;
                stan::math::assign(Qr, initV);
                current_statement_begin__ = 89;
                stan::math::assign(Qp, initV);
                current_statement_begin__ = 90;
                stan::math::assign(Qsum, initV);
                current_statement_begin__ = 92;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 94;
                    lp_accum__.add(categorical_log<propto__>(get_base1(get_base1(choice,i,"choice",1),t,"choice",2), add(multiply(softmax(Qsum),(1 - get_base1(xi,i,"xi",1))),(get_base1(xi,i,"xi",1) / 4))));
                    current_statement_begin__ = 97;
                    stan::math::assign(PEr, ((get_base1(R,i,"R",1) * get_base1(get_base1(rew,i,"rew",1),t,"rew",2)) - get_base1(Qr,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"Qr",1)));
                    current_statement_begin__ = 98;
                    stan::math::assign(PEp, ((get_base1(P,i,"P",1) * get_base1(get_base1(los,i,"los",1),t,"los",2)) - get_base1(Qp,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"Qp",1)));
                    current_statement_begin__ = 99;
                    stan::math::assign(PEr_fic, minus(Qr));
                    current_statement_begin__ = 100;
                    stan::math::assign(PEp_fic, minus(Qp));
                    current_statement_begin__ = 103;
                    stan::math::assign(Qr_chosen, get_base1(Qr,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"Qr",1));
                    current_statement_begin__ = 104;
                    stan::math::assign(Qp_chosen, get_base1(Qp,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"Qp",1));
                    current_statement_begin__ = 107;
                    stan::math::assign(Qr, add(Qr, multiply(get_base1(Arew,i,"Arew",1),PEr_fic)));
                    current_statement_begin__ = 108;
                    stan::math::assign(Qp, add(Qp, multiply(get_base1(Apun,i,"Apun",1),PEp_fic)));
                    current_statement_begin__ = 110;
                    stan::model::assign(Qr, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), 
                                (Qr_chosen + (get_base1(Arew,i,"Arew",1) * PEr)), 
                                "assigning variable Qr");
                    current_statement_begin__ = 111;
                    stan::model::assign(Qp, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), 
                                (Qp_chosen + (get_base1(Apun,i,"Apun",1) * PEp)), 
                                "assigning variable Qp");
                    current_statement_begin__ = 114;
                    stan::math::assign(Qsum, add(Qr,Qp));
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("Arew_pr");
        names__.push_back("Apun_pr");
        names__.push_back("R_pr");
        names__.push_back("P_pr");
        names__.push_back("xi_pr");
        names__.push_back("Arew");
        names__.push_back("Apun");
        names__.push_back("R");
        names__.push_back("P");
        names__.push_back("xi");
        names__.push_back("mu_Arew");
        names__.push_back("mu_Apun");
        names__.push_back("mu_R");
        names__.push_back("mu_P");
        names__.push_back("mu_xi");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(5);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(5);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_bandit4arm_lapse_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(5);
        vector_d sigma = in__.vector_lb_constrain(0,5);
        vector_d Arew_pr = in__.vector_constrain(N);
        vector_d Apun_pr = in__.vector_constrain(N);
        vector_d R_pr = in__.vector_constrain(N);
        vector_d P_pr = in__.vector_constrain(N);
        vector_d xi_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 5; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 5; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Arew_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Apun_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(R_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(P_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 47;
            validate_non_negative_index("Arew", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Arew(static_cast<Eigen::VectorXd::Index>(N));
            (void) Arew;  // dummy to suppress unused var warning

            stan::math::initialize(Arew, DUMMY_VAR__);
            stan::math::fill(Arew,DUMMY_VAR__);
            current_statement_begin__ = 48;
            validate_non_negative_index("Apun", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Apun(static_cast<Eigen::VectorXd::Index>(N));
            (void) Apun;  // dummy to suppress unused var warning

            stan::math::initialize(Apun, DUMMY_VAR__);
            stan::math::fill(Apun,DUMMY_VAR__);
            current_statement_begin__ = 49;
            validate_non_negative_index("R", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  R(static_cast<Eigen::VectorXd::Index>(N));
            (void) R;  // dummy to suppress unused var warning

            stan::math::initialize(R, DUMMY_VAR__);
            stan::math::fill(R,DUMMY_VAR__);
            current_statement_begin__ = 50;
            validate_non_negative_index("P", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  P(static_cast<Eigen::VectorXd::Index>(N));
            (void) P;  // dummy to suppress unused var warning

            stan::math::initialize(P, DUMMY_VAR__);
            stan::math::fill(P,DUMMY_VAR__);
            current_statement_begin__ = 51;
            validate_non_negative_index("xi", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
            (void) xi;  // dummy to suppress unused var warning

            stan::math::initialize(xi, DUMMY_VAR__);
            stan::math::fill(xi,DUMMY_VAR__);


            current_statement_begin__ = 53;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 54;
                stan::model::assign(Arew, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(Arew_pr,i,"Arew_pr",1)))), 
                            "assigning variable Arew");
                current_statement_begin__ = 55;
                stan::model::assign(Apun, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(Apun_pr,i,"Apun_pr",1)))), 
                            "assigning variable Apun");
                current_statement_begin__ = 56;
                stan::model::assign(R, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(R_pr,i,"R_pr",1)))) * 30), 
                            "assigning variable R");
                current_statement_begin__ = 57;
                stan::model::assign(P, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,4,"mu_pr",1) + (get_base1(sigma,4,"sigma",1) * get_base1(P_pr,i,"P_pr",1)))) * 30), 
                            "assigning variable P");
                current_statement_begin__ = 58;
                stan::model::assign(xi, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,5,"mu_pr",1) + (get_base1(sigma,5,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))), 
                            "assigning variable xi");
            }

            // validate transformed parameters
            current_statement_begin__ = 47;
            check_greater_or_equal(function__,"Arew",Arew,0);
            check_less_or_equal(function__,"Arew",Arew,1);
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"Apun",Apun,0);
            check_less_or_equal(function__,"Apun",Apun,1);
            current_statement_begin__ = 49;
            check_greater_or_equal(function__,"R",R,0);
            check_less_or_equal(function__,"R",R,30);
            current_statement_begin__ = 50;
            check_greater_or_equal(function__,"P",P,0);
            check_less_or_equal(function__,"P",P,30);
            current_statement_begin__ = 51;
            check_greater_or_equal(function__,"xi",xi,0);
            check_less_or_equal(function__,"xi",xi,1);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Arew[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Apun[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(R[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(P[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 120;
            local_scalar_t__ mu_Arew;
            (void) mu_Arew;  // dummy to suppress unused var warning

            stan::math::initialize(mu_Arew, DUMMY_VAR__);
            stan::math::fill(mu_Arew,DUMMY_VAR__);
            current_statement_begin__ = 121;
            local_scalar_t__ mu_Apun;
            (void) mu_Apun;  // dummy to suppress unused var warning

            stan::math::initialize(mu_Apun, DUMMY_VAR__);
            stan::math::fill(mu_Apun,DUMMY_VAR__);
            current_statement_begin__ = 122;
            local_scalar_t__ mu_R;
            (void) mu_R;  // dummy to suppress unused var warning

            stan::math::initialize(mu_R, DUMMY_VAR__);
            stan::math::fill(mu_R,DUMMY_VAR__);
            current_statement_begin__ = 123;
            local_scalar_t__ mu_P;
            (void) mu_P;  // dummy to suppress unused var warning

            stan::math::initialize(mu_P, DUMMY_VAR__);
            stan::math::fill(mu_P,DUMMY_VAR__);
            current_statement_begin__ = 124;
            local_scalar_t__ mu_xi;
            (void) mu_xi;  // dummy to suppress unused var warning

            stan::math::initialize(mu_xi, DUMMY_VAR__);
            stan::math::fill(mu_xi,DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 130;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<local_scalar_t__> > y_pred(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 133;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 134;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 135;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred");
                }
            }
            current_statement_begin__ = 139;
            stan::math::assign(mu_Arew, Phi_approx(get_base1(mu_pr,1,"mu_pr",1)));
            current_statement_begin__ = 140;
            stan::math::assign(mu_Apun, Phi_approx(get_base1(mu_pr,2,"mu_pr",1)));
            current_statement_begin__ = 141;
            stan::math::assign(mu_R, (Phi_approx(get_base1(mu_pr,3,"mu_pr",1)) * 30));
            current_statement_begin__ = 142;
            stan::math::assign(mu_P, (Phi_approx(get_base1(mu_pr,4,"mu_pr",1)) * 30));
            current_statement_begin__ = 143;
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_pr,5,"mu_pr",1)));

            current_statement_begin__ = 146;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 148;
                validate_non_negative_index("Qr", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Qr(static_cast<Eigen::VectorXd::Index>(4));
                (void) Qr;  // dummy to suppress unused var warning

                stan::math::initialize(Qr, DUMMY_VAR__);
                stan::math::fill(Qr,DUMMY_VAR__);
                current_statement_begin__ = 149;
                validate_non_negative_index("Qp", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Qp(static_cast<Eigen::VectorXd::Index>(4));
                (void) Qp;  // dummy to suppress unused var warning

                stan::math::initialize(Qp, DUMMY_VAR__);
                stan::math::fill(Qp,DUMMY_VAR__);
                current_statement_begin__ = 150;
                validate_non_negative_index("PEr_fic", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  PEr_fic(static_cast<Eigen::VectorXd::Index>(4));
                (void) PEr_fic;  // dummy to suppress unused var warning

                stan::math::initialize(PEr_fic, DUMMY_VAR__);
                stan::math::fill(PEr_fic,DUMMY_VAR__);
                current_statement_begin__ = 151;
                validate_non_negative_index("PEp_fic", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  PEp_fic(static_cast<Eigen::VectorXd::Index>(4));
                (void) PEp_fic;  // dummy to suppress unused var warning

                stan::math::initialize(PEp_fic, DUMMY_VAR__);
                stan::math::fill(PEp_fic,DUMMY_VAR__);
                current_statement_begin__ = 152;
                validate_non_negative_index("Qsum", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  Qsum(static_cast<Eigen::VectorXd::Index>(4));
                (void) Qsum;  // dummy to suppress unused var warning

                stan::math::initialize(Qsum, DUMMY_VAR__);
                stan::math::fill(Qsum,DUMMY_VAR__);
                current_statement_begin__ = 154;
                local_scalar_t__ Qr_chosen;
                (void) Qr_chosen;  // dummy to suppress unused var warning

                stan::math::initialize(Qr_chosen, DUMMY_VAR__);
                stan::math::fill(Qr_chosen,DUMMY_VAR__);
                current_statement_begin__ = 155;
                local_scalar_t__ Qp_chosen;
                (void) Qp_chosen;  // dummy to suppress unused var warning

                stan::math::initialize(Qp_chosen, DUMMY_VAR__);
                stan::math::fill(Qp_chosen,DUMMY_VAR__);
                current_statement_begin__ = 156;
                local_scalar_t__ PEr;
                (void) PEr;  // dummy to suppress unused var warning

                stan::math::initialize(PEr, DUMMY_VAR__);
                stan::math::fill(PEr,DUMMY_VAR__);
                current_statement_begin__ = 157;
                local_scalar_t__ PEp;
                (void) PEp;  // dummy to suppress unused var warning

                stan::math::initialize(PEp, DUMMY_VAR__);
                stan::math::fill(PEp,DUMMY_VAR__);


                current_statement_begin__ = 160;
                stan::math::assign(Qr, initV);
                current_statement_begin__ = 161;
                stan::math::assign(Qp, initV);
                current_statement_begin__ = 162;
                stan::math::assign(Qsum, initV);
                current_statement_begin__ = 163;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0.0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 165;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 167;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + categorical_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),add(multiply(softmax(Qsum),(1 - get_base1(xi,i,"xi",1))),(get_base1(xi,i,"xi",1) / 4)))), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 170;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                categorical_rng(add(multiply(softmax(Qsum),(1 - get_base1(xi,i,"xi",1))),(get_base1(xi,i,"xi",1) / 4)), base_rng__), 
                                "assigning variable y_pred");
                    current_statement_begin__ = 173;
                    stan::math::assign(PEr, ((get_base1(R,i,"R",1) * get_base1(get_base1(rew,i,"rew",1),t,"rew",2)) - get_base1(Qr,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"Qr",1)));
                    current_statement_begin__ = 174;
                    stan::math::assign(PEp, ((get_base1(P,i,"P",1) * get_base1(get_base1(los,i,"los",1),t,"los",2)) - get_base1(Qp,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"Qp",1)));
                    current_statement_begin__ = 175;
                    stan::math::assign(PEr_fic, minus(Qr));
                    current_statement_begin__ = 176;
                    stan::math::assign(PEp_fic, minus(Qp));
                    current_statement_begin__ = 179;
                    stan::math::assign(Qr_chosen, get_base1(Qr,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"Qr",1));
                    current_statement_begin__ = 180;
                    stan::math::assign(Qp_chosen, get_base1(Qp,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"Qp",1));
                    current_statement_begin__ = 183;
                    stan::math::assign(Qr, add(Qr, multiply(get_base1(Arew,i,"Arew",1),PEr_fic)));
                    current_statement_begin__ = 184;
                    stan::math::assign(Qp, add(Qp, multiply(get_base1(Apun,i,"Apun",1),PEp_fic)));
                    current_statement_begin__ = 186;
                    stan::model::assign(Qr, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), 
                                (Qr_chosen + (get_base1(Arew,i,"Arew",1) * PEr)), 
                                "assigning variable Qr");
                    current_statement_begin__ = 187;
                    stan::model::assign(Qp, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), 
                                (Qp_chosen + (get_base1(Apun,i,"Apun",1) * PEp)), 
                                "assigning variable Qp");
                    current_statement_begin__ = 190;
                    stan::math::assign(Qsum, add(Qr,Qp));
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 120;
            check_greater_or_equal(function__,"mu_Arew",mu_Arew,0);
            check_less_or_equal(function__,"mu_Arew",mu_Arew,1);
            current_statement_begin__ = 121;
            check_greater_or_equal(function__,"mu_Apun",mu_Apun,0);
            check_less_or_equal(function__,"mu_Apun",mu_Apun,1);
            current_statement_begin__ = 122;
            check_greater_or_equal(function__,"mu_R",mu_R,0);
            check_less_or_equal(function__,"mu_R",mu_R,30);
            current_statement_begin__ = 123;
            check_greater_or_equal(function__,"mu_P",mu_P,0);
            check_less_or_equal(function__,"mu_P",mu_P,30);
            current_statement_begin__ = 124;
            check_greater_or_equal(function__,"mu_xi",mu_xi,0);
            check_less_or_equal(function__,"mu_xi",mu_xi,1);
            current_statement_begin__ = 127;
            current_statement_begin__ = 130;

            // write generated quantities
        vars__.push_back(mu_Arew);
        vars__.push_back(mu_Apun);
        vars__.push_back(mu_R);
        vars__.push_back(mu_P);
        vars__.push_back(mu_xi);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_bandit4arm_lapse";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Arew_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Apun_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "P_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Arew" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Apun" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "P" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Arew";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Apun";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_R";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_P";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Arew_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Apun_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "P_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Arew" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Apun" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "P" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xi" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Arew";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Apun";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_R";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_P";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_bandit4arm_lapse_namespace::model_bandit4arm_lapse stan_model;


#endif
