% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{retype}
\alias{retype}
\alias{retype.default}
\alias{retype.logical}
\alias{retype.integer}
\alias{retype.Date}
\alias{retype.POSIXct}
\alias{retype.numeric}
\alias{retype.list}
\alias{retype.data.frame}
\title{Return simple data types}
\usage{
retype(.x, ...)

\method{retype}{default}(.x, ...)

\method{retype}{logical}(.x, ...)

\method{retype}{integer}(.x, ...)

\method{retype}{Date}(.x, ...)

\method{retype}{POSIXct}(.x, ...)

\method{retype}{numeric}(.x, ...)

\method{retype}{list}(.x, ...)

\method{retype}{data.frame}(.x, ...)
}
\arguments{
\item{.x}{vector or data.frame}

\item{...}{column names to be evaluated. Only if .x is a data frame.}
}
\value{
For vectors: simple class of .x.

For data.frame: a tbl data frame with simple classes.

\code{NULL}

\code{NULL}

\code{NULL}

\code{NULL}

\code{NULL}

\code{NULL}

\code{NULL}

\code{NULL}
}
\description{
\code{retype} transforms all elements into simple classes. The simple classes
are date, numeric and character. By transforming all elements to these
classes no information is lost, while simplifying the object. See details below for
more information or type \code{vignette("retype")} in the console.
}
\details{
Each vector past to \code{retype} is reclassified into the highest position in
a simplification hierarchy without loosing any information. This means that:
Factors are converted to characters.
However, character vectors (or vectors changed to character initially)
are checked to see if they could be a numeric vector without error.
If so, it is transformed into a numeric vector which is higher in the hierarchy.
Vectors of class logical, integer are changed to numerical.
Dates and date time (POSIXct) goes through the same procedure.
Lists and complex vectors are left unchanged because the are neither simple nor complicated.
}
\examples{
# Dates
dte <- as.Date(c("2018-01-01", "2016-03-21", "1970-01-05"))
retype(dte)
retype(dte)

# Factors
fct <- as.factor(c("good", "bad", "average"))
retype(dte)

# Character that only contains numeric elements
num_chr <- c("3","4.0", "3,5")
retype(num_chr)

# Logical
lgl <- c(TRUE, FALSE, TRUE)
retype(lgl)

# Data frame with all the above vectors
df <- data.frame(dte = dte, 
                 fct = fct, 
                 num_chr = num_chr, 
                 lgl = lgl, 
                 stringsAsFactos = FALSE)
df
retype(df)

}
\seealso{
\code{\link{s}}, \code{\link{rationalize}}
}
