% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_format.R
\name{format_template_data}
\alias{format_template_data}
\title{Format Template Data}
\usage{
format_template_data(template)
}
\arguments{
\item{template}{A single cluster template created by
\code{\link[=make_clustering_template]{make_clustering_template()}}}
}
\value{
List that contains the cluster fill counts
}
\description{
\code{format_template_data()} formats the template data for use with
\code{\link[=plot_cluster_fill_counts]{plot_cluster_fill_counts()}}. The output is a list that contains a data frame
called \code{cluster_fill_counts}.
}
\examples{
template_data <- format_template_data(template = example_cluster_template)
plot_cluster_fill_counts(formatted_data = template_data, facet = TRUE)

}
