% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lords_divisions.R
\name{lords_divisions}
\alias{lords_divisions}
\title{Imports data on House of Lords divisions}
\usage{
lords_divisions(division_id = NULL, summary = FALSE,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{division_id}{The id of a particular vote. If empty, returns a tibble with information on all lords divisions. Defaults to NULL.}

\item{summary}{If TRUE, returns a small tibble summarising a division outcome. Otherwise returns a tibble with details on how each peer voted. Has no effect if `division_id` is empty. Defaults to FALSE.}

\item{start_date}{The earliest date to include in the tibble, if calling all divisions. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble, if calling all divisions. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Removes extra URL data from voting type columns.  Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with the results of divisions in the House of Lords.
}
\description{
Imports data on House of Lords divisions
}
\examples{
\dontrun{

x <- lords_divisions(division_id = 705891, summary = TRUE)

x <- lords_divisions(division_id = 705891, summary = FALSE)

# Return all lords divisions in 2016
x <- lords_divisions(NULL, FALSE, start_date = '2016-01-01', end_date = '2016-12-31')

}
}
\keyword{Divisions}
\keyword{Lords}
