% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_vote_record.R
\name{mp_vote_record}
\alias{mp_vote_record}
\alias{hansard_mp_vote_record}
\title{Individual MP voting records}
\usage{
mp_vote_record(mp_id = NULL, lobby = "all", session = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")

hansard_mp_vote_record(mp_id = NULL, lobby = "all", session = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{mp_id}{The ID number of a member of the House of Commons.}

\item{lobby}{Accepts one of 'all', 'aye' or 'no'. 'aye' returns votes where the MP voted 'aye', 'no' returns votes where the MP voted 'no', 'all' returns all available votes by the MP. Defaults to 'all'.}

\item{session}{The parliamentary session to return votes from, in 'YYYY/YY' format. Defaults to NULL.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with details on the voting record of the given MP.
}
\description{
Accepts an ID number for a member of the House of Commons, and returns a tibble of their votes.
}
\examples{
\dontrun{
x <- mp_vote_record(172, lobby='all')

x <- mp_vote_record(172, lobby='aye')

x <- mp_vote_record(172, lobby='no')

x <- mp_vote_record(172, session = '2016/17')

}
}
\keyword{divisions}
