% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_raw_lidar.R
\name{get_raw_lidar}
\alias{get_raw_lidar}
\title{Download raw LIDAR data}
\usage{
get_raw_lidar(shape, destfile = ".", grid_path = ".", quiet = F)
}
\arguments{
\item{shape}{Object of class \code{sf}. Needs to be located in
France.}

\item{destfile}{folder path where data are downloaded. By default set to "." e.g. the current directory}

\item{grid_path}{folder path where grid is downloaded. By default set to "." e.g. the current directory}

\item{quiet}{if TRUE download is silent}
}
\value{
No object
}
\description{
The raw LIDAR data are not classified. They correspond to a point cloud.
}
\details{
\code{get_raw_lidar} first downloads a grid containing the name of LIDAR tiles which is
then intersected with \code{shape} to determine which ones will be uploaded.
The grid is downloaded to \code{grid_path} if it is not already in the folder.

\code{get_raw_lidar} automatically compares the required tiles to those already in
the \code{destfile} to avoid re-downloading them.
}
\examples{
\dontrun{
library(sf)

# create shape
shape <- st_polygon(list(matrix(c(8.852234, 42.55466,
                                  8.852234, 42.57289,
                                  8.860474, 42.57289,
                                  8.860474, 42.55466,
                                  8.852234, 42.55466),
                                 ncol = 2, byrow = TRUE)))
shape <- st_sfc(shape, crs = st_crs(4326))

# Download data to current directory
get_raw_lidar(shape)

# Check all .laz file
list.files(".", pattern = ".laz", recursive = TRUE)
}

}
