% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wmts.R
\name{get_wmts}
\alias{get_wmts}
\title{Download WMTS raster tiles}
\usage{
get_wmts(x,
         apikey = "ortho",
         layer = "ORTHOIMAGERY.ORTHOPHOTOS",
         zoom = 6L,
         crs = 2154,
         filename = tempfile(fileext = ".tif"),
         overwrite = TRUE)
}
\arguments{
\item{x}{Object of class \code{sf} or \code{sfc}. Needs to be located in
France.}

\item{apikey}{\code{character}; API key from \code{get_apikeys()} or directly
from \href{https://geoservices.ign.fr/services-web-experts}{IGN website}.}

\item{layer}{\code{character}; layer name from
\code{get_layers_metadata(apikey, "wms")} or directly from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}.}

\item{zoom}{\code{integer} between 0 and 21; at low zoom levels, a small set of
map tiles covers a large geographical area. In other words, the smaller
the zoom level, the less precise the resolution. For conversion between zoom
level and resolution see
\href{https://geoservices.ign.fr/documentation/services/api-et-services-ogc/images-tuilees-wmts-ogc}{WMTS IGN Documentation}}

\item{crs}{\code{numeric}, \code{character}, or object of class \code{sf} or \code{sfc}.
It is set to EPSG:2154 by default. See \code{\link[sf:st_crs]{sf::st_crs()}} for more detail.}

\item{filename}{\code{character} or \code{NULL}; filename or a open connection for
writing. (ex : "test.tif" or "~/test.tif"). If \code{NULL}, \code{layer} is used as
filename. Default drivers is ".tif" but all gdal drivers are supported,
see details for more info.}

\item{overwrite}{If TRUE, output raster is overwrite.}
}
\value{
\code{SpatRaster} object from \code{terra} package.
}
\description{
Download an RGB raster layer from IGN Web Map Tile Services (WMTS).
WMTS focuses on performance and can only query pre-calculated
tiles.
}
\examples{
\dontrun{
TO-DO
}
}
\seealso{
\code{\link[=get_apikeys]{get_apikeys()}}, \code{\link[=get_layers_metadata]{get_layers_metadata()}}
}
