% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmo_sax.R
\name{hmo_sax}
\alias{hmo_sax}
\title{Motif discovery using SAX}
\usage{
hmo_sax(a, w, qtd = 2)
}
\arguments{
\item{a}{alphabet size}

\item{w}{word size}

\item{qtd}{number of occurrences to be classified as motifs}
}
\value{
\code{hmo_sax} object
}
\description{
Motif discovery using SAX \url{doi:10.1007/s10618-007-0064-z}
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_motifs)

#Using sequence example
dataset <- examples_motifs$simple
head(dataset)

# setting up motif discovery method
model <- hmo_sax(26, 3, 3)

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
