% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{Client}
\alias{Client}
\title{Client Class}
\description{
The Client is the central gateway for interfacing with the HDA Service.
It provides a comprehensive suite of methods to perform operations and retrieve data from the service efficiently.
}
\note{
There are some inconsistencies between the return of `GET querymetadata` and what must be submitted to the HDA.
Use \code{\link[=Client]{generate_query_template}} to resolve these inconsistencies.
}
\seealso{
\code{\link[=Client]{show_terms}} to read the Terms and conditions.

\code{\link[=SearchResults]{SearchResults}} for details on the returned object.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{apiUrl}}{API endpoint}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Client-new}{\code{Client$new()}}
\item \href{#method-Client-token}{\code{Client$token()}}
\item \href{#method-Client-get_token}{\code{Client$get_token()}}
\item \href{#method-Client-send_request}{\code{Client$send_request()}}
\item \href{#method-Client-show_terms}{\code{Client$show_terms()}}
\item \href{#method-Client-terms_and_conditions}{\code{Client$terms_and_conditions()}}
\item \href{#method-Client-datasets}{\code{Client$datasets()}}
\item \href{#method-Client-search}{\code{Client$search()}}
\item \href{#method-Client-get_querytemplate}{\code{Client$get_querytemplate()}}
\item \href{#method-Client-generate_query_template}{\code{Client$generate_query_template()}}
\item \href{#method-Client-clone}{\code{Client$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-new"></a>}}
\if{latex}{\out{\hypertarget{method-Client-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the `Client` class. Initializes a new instance with authentication credentials.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$new(user, password, save_credentials = FALSE, credentials_dir = "./")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{Character string representing the username for authentication.}

\item{\code{password}}{Character string representing the password for authentication.}

\item{\code{save_credentials}}{A logical value indicating whether to save the credentials to a configuration file. Default is FALSE.}

\item{\code{credentials_dir}}{Directory where the credentials file will be saved. Defaults to `"./"`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of the `Client` class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-token"></a>}}
\if{latex}{\out{\hypertarget{method-Client-token}{}}}
\subsection{Method \code{token()}}{
Retrieves the current authentication token.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$token()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character string representing the authentication token.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-get_token"></a>}}
\if{latex}{\out{\hypertarget{method-Client-get_token}{}}}
\subsection{Method \code{get_token()}}{
Generates a new authentication token.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$get_token()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character string representing the newly generated token.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-send_request"></a>}}
\if{latex}{\out{\hypertarget{method-Client-send_request}{}}}
\subsection{Method \code{send_request()}}{
Sends a specified request to the server and returns the response.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$send_request(req, raw_response = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{A request object or list representing the HTTP request.}

\item{\code{raw_response}}{Optional logical value indicating whether the raw response should be returned instead of the parsed body.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A response object containing the server's response.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-show_terms"></a>}}
\if{latex}{\out{\hypertarget{method-Client-show_terms}{}}}
\subsection{Method \code{show_terms()}}{
This function displays the terms and conditions for the services.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$show_terms()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An HTML document containing the terms and conditions in a collapsible format.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-terms_and_conditions"></a>}}
\if{latex}{\out{\hypertarget{method-Client-terms_and_conditions}{}}}
\subsection{Method \code{terms_and_conditions()}}{
Function to retrieve and accept terms and conditions. Accepting T&C is permanent,
it is enough to run this function one.
To read T&C see \code{\link[=Client]{show_terms}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$terms_and_conditions(term_id, reject = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{term_id}}{A character vector of term_ids that you wish to accept.
If missing current status is returned.
Use "\strong{all}" if you want to accept all terms at once.}

\item{\code{reject}}{Logical, default 'FALSE'. If TRUE it inverts the operation and
the provided term_id's are rejected/revoked.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame reflecting the actual acceptance status for each term.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-datasets"></a>}}
\if{latex}{\out{\hypertarget{method-Client-datasets}{}}}
\subsection{Method \code{datasets()}}{
Lists datasets available on WEkEO, optionally filtered by a text pattern.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$datasets(pattern = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{Optional character string to filter dataset names by matching text.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List containing datasets and associated information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-search"></a>}}
\if{latex}{\out{\hypertarget{method-Client-search}{}}}
\subsection{Method \code{search()}}{
This function performs a search based on a specified query and returns an instance of \code{\link{SearchResults}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$search(json_query, limit = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_query}}{Character string representing the search query.}

\item{\code{limit}}{Optional; a number specifying the maximum number of results to return.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of the \code{\link{SearchResults}} class containing the search results.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-get_querytemplate"></a>}}
\if{latex}{\out{\hypertarget{method-Client-get_querytemplate}{}}}
\subsection{Method \code{get_querytemplate()}}{
Retrieves the raw query metadata for a specified datasetId.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$get_querytemplate(datasetId, to_json = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{datasetId}}{Character, representing the dataset's identifier.}

\item{\code{to_json}}{Logical; if `TRUE`, returns the data in JSON format.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List or JSON file containing the raw query options.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-generate_query_template"></a>}}
\if{latex}{\out{\hypertarget{method-Client-generate_query_template}{}}}
\subsection{Method \code{generate_query_template()}}{
This function generates a query template based on a specified datasetId.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$generate_query_template(datasetId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{datasetId}}{A numeric or character ID representing the dataset.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A JSON representing the generated query template.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Client-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Client-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
