% Generated by roxygen2 (4.0.1): do not edit by hand
\name{GRDCCatalogue}
\alias{GRDCCatalogue}
\title{Interface for the Global Runoff Data Centre database catalogue}
\usage{
GRDCCatalogue(stationID = NULL, lonMin = -180, lonMax = +180,
  latMin = -90, latMax = +90, mdDescription = FALSE)
}
\arguments{
\item{stationID}{Station ID number, it should be in the range [1104150,6990700]}

\item{lonMin}{Minimum latitude of bounding box}

\item{lonMax}{Maximum latitude of bounding box}

\item{latMin}{Minimum longitude of bounding box}

\item{latMax}{Maximum longitude of bounding box}

\item{mdDescription}{boolean value. Default is FALSE (no description is printed)}
}
\value{
list of stations within the bounding box
}
\description{
This function interfaces the Global Runoff Data Centre database which provides river discharge data for about 9000 sites over 157 countries.
}
\examples{
GRDCCatalogue(lonMin=-3.82,lonMax=-3.63,latMin=52.43,latMax=52.52)
}
\author{
Claudia Vitolo
}

