% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-find-variation.R
\name{createAllCombinations}
\alias{createAllCombinations}
\title{Find all possible unique combinations}
\usage{
createAllCombinations(vector)
}
\arguments{
\item{vector}{A vector of strings or numbers.}
}
\value{
A list of sub-lists. Each sub-list represents one possible 
combination.
}
\description{
For a given vector of, find all possible combinations of the
values. When calculating, if two groups contain the same values, they are
counted as the same if they only differ in terms of ordering.
}
\examples{
vector <- c("LactateOrderHospital",
                  "LactateOrderProvSpecialtyDSC",
                  "LactateOrderProvNM")
res <- createAllCombinations(vector)

# Let's look at one possible combination
unlist(res[3])

# Look at all possible combinations
res
}
\references{
\url{http://healthcareai-r.readthedocs.io}
}
\seealso{
\code{\link{healthcareai}} \code{\link{findVariation}} 
\code{\link{createVarianceTallTable}}
}
