% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-nelson-rules.R
\name{nelsonRule1}
\alias{nelsonRule1}
\title{Analyze points in time to determine whether or not Nelson Rule 1 was violated}
\usage{
nelsonRule1(df, measure_col, date_col, plot_flg = TRUE)
}
\arguments{
\item{df}{A data frame}

\item{measure_col}{A string denoting the column that contains the numeric
value to be evaluated by the nelsonRule1 function}

\item{date_col}{A string denoting the date column used for evaluating
Nelson Rule 1 over time}

\item{plot_flg}{A binary indicator of whether or not to include a plot in the
output of the function}
}
\value{
A data frame containing the date, measure value, uppper control
limit, lower control limit, a flag indicating whether or not a rule violation
occured and a description of the violation.
}
\description{
Search within a data frame to find violations of Nelson Rule 1.
Nelson Rule 1: One point is more than 3 standard deviations from the mean.
}
\examples{
library(healthcareai)
date <- seq.Date(from = as.Date('2016-01-03'), length.out = 52, by = 'week')
set.seed(34)
measureValue <- rnorm(length(date), mean = 100, sd = 15)

# Alter some measureValues to be at least 3 standard deviations from the mean
# so they can be displayed as violation examples.
measureValue[9] <- 179
measureValue[19] <- 22
measureValue[47] <- 177

d <- data.frame(date, measureValue)

nr1 <- nelsonRule1(df = d, measure_col = 'measureValue', date_col = 'date')

nr1
}
\references{
\url{http://healthcareai-r.readthedocs.io}
\url{https://en.wikipedia.org/wiki/Nelson_rules}
}
\seealso{
\code{\link{healthcareai}}
}
