% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_models.R
\name{flash_models}
\alias{flash_models}
\title{Train models without tuning for performance}
\usage{
flash_models(d, outcome, models, metric, positive_class, n_folds = 5,
  model_class, model_name = NULL, allow_parallel = FALSE)
}
\arguments{
\item{d}{A data frame}

\item{outcome}{Name of the column to predict}

\item{models}{Names of models to try. See \code{\link{get_supported_models}}
for available models. Default is all available models.}

\item{metric}{What metric to use to assess model performance? Options for
regression: "RMSE" (root-mean-squared error, default), "MAE" (mean-absolute
error), or "Rsquared." For classification: "ROC" (area under the receiver
operating characteristic curve), or "PR" (area under the precision-recall
curve).}

\item{positive_class}{For classification only, which outcome level is the
"yes" case, i.e. should be associated with high probabilities? Defaults to
"Y" or "yes" if present, otherwise is the first level of the outcome
variable (first alphabetically if the training data outcome was not already
a factor).}

\item{n_folds}{How many folds to train the model on. Default = 5, minimum =
2. Whie flash_models doesn't use cross validation to tune hyperparameters,
it trains \code{n_folds} models to evaluate performance out of fold.}

\item{model_class}{"regression" or "classification". If not provided, this
will be determined by the class of `outcome` with the determination
displayed in a message.}

\item{model_name}{Quoted, name of the model. Defaults to the name of the
outcome variable.}

\item{allow_parallel}{Logical, defaults to FALSE. If TRUE and a parallel
backend is set up (e.g. with \code{doMC}) models with support for parallel
training will be trained across cores.}
}
\value{
A model_list object. You can call \code{plot}, \code{summary},
  \code{evaluate}, or \code{predict} on a model_list.
}
\description{
Train models without tuning for performance
}
\details{
This function has two major differences from
  \code{\link{tune_models}}: 1. It uses fixed default hyperparameter values
  to train models instead of using cross-validation to optimize
  hyperparameter values for predictive performance, and, as a result, 2. It
  is much faster.

  If you want to train a model at a single set of non-default hyperparameter
  values use \code{\link{tune_models}} and pass a single-row data frame to
  the hyperparameters arguemet.
}
\examples{
\dontrun{
# Prepare data
prepped_data <- prep_data(pima_diabetes, patient_id, outcome = diabetes)

# Get models quickly at default hyperparameter values
flash_models(prepped_data, diabetes)

# Speed comparison of no tuning with flash_models vs. tuning with tune_models:
# ~15 seconds:
system.time(
  tune_models(prepped_data, diabetes)
)
# ~3 seconds:
system.time(
  flash_models(prepped_data, diabetes)
)
}
}
\seealso{
For setting up model training: \code{\link{prep_data}},
  \code{\link{supported_models}}, \code{\link{hyperparameters}}

  For evaluating models: \code{\link{plot.model_list}},
  \code{\link{evaluate.model_list}}

  For making predictions: \code{\link{predict.model_list}}

  For optimizing performance: \code{\link{tune_models}}

  To prepare data and tune models in a single step:
  \code{\link{machine_learn}}
}
