% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_importance.R
\name{plot.variable_importance}
\alias{plot.variable_importance}
\title{Plot variable importance}
\usage{
\method{plot}{variable_importance}(x, title = "model", max_char = 40,
  caption = NULL, font_size = 11, point_size = 3, print = TRUE, ...)
}
\arguments{
\item{x}{A data frame from \code{\link{get_variable_importance}}}

\item{title}{Either "model", "none", or a string to be used as the plot
caption. "model" puts the name of the best-performing model, on which
variable importances are generated, in the title.}

\item{max_char}{Maximum length of variable names to leave untruncated.
Default = 40; use \code{Inf} to prevent truncation. Variable names longer
than this will be truncated to leave the beginning and end of each variable
name, bridged by " ... ".}

\item{caption}{Plot title}

\item{font_size}{Relative size for all fonts, default = 11}

\item{point_size}{Size of dots, default = 3}

\item{print}{Print the plot?}

\item{...}{Unused}
}
\value{
A ggplot object, invisibly.
}
\description{
Plot variable importance
}
\examples{
machine_learn(pima_diabetes[1:50, ], patient_id, outcome = diabetes, tune = FALSE) \%>\%
  get_variable_importance() \%>\%
  plot()
}
