% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hellmer-core.R
\name{process}
\alias{process}
\title{Process batch of prompts with progress tracking and retries}
\usage{
process(
  chat_obj,
  prompts,
  type_spec = NULL,
  state_path = tempfile("chat_", fileext = ".rds"),
  echo = "none",
  max_retries = 3L,
  initial_delay = 1,
  max_delay = 60,
  backoff_factor = 2,
  timeout = 60,
  beep = TRUE
)
}
\arguments{
\item{chat_obj}{Chat model object}

\item{prompts}{List of prompts}

\item{type_spec}{Type specification for structured data}

\item{state_path}{Path for saving state}

\item{echo}{Echo level ("none", "text", or "all")}

\item{max_retries}{Maximum number of retry attempts per prompt}

\item{initial_delay}{Initial delay in seconds before first retry}

\item{max_delay}{Maximum delay in seconds between retries}

\item{backoff_factor}{Factor to multiply delay by after each retry}

\item{timeout}{Maximum time in seconds to wait for each prompt response}

\item{beep}{Play sound on completion, interruption, and error}
}
\value{
Batch results object
}
\description{
Process batch of prompts with progress tracking and retries
}
\keyword{internal}
