% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather.R
\name{weather}
\alias{weather}
\title{HERE Destination Weather API: Observations, Forecast, Astronomy and Alerts}
\usage{
weather(poi, product = "observation", url_only = FALSE)
}
\arguments{
\item{poi}{\code{sf} object or character, Points of Interest (POIs) of geometry type \code{POINT} or location names (e.g. cities or regions).}

\item{product}{character, weather product of the 'Destination Weather API'. Supported products: \code{"observation"}, \code{"forecast_hourly"}, \code{"forecast_astronomy"} and \code{"alerts"}.}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object containing the requested weather information at the nearest weather station.
The point geometry in the \code{sf} object is the location of the weather station.
}
\description{
Weather forecasts, reports on current weather conditions,
astronomical information and alerts at a specific location (coordinates or
location name) based on the 'Destination Weather' API.
The information comes from the nearest available weather station and is not interpolated.
}
\examples{
# Authentication
set_auth(
  app_id = "<YOUR APP ID>",
  app_code = "<YOUR APP CODE>"
)

# Observation
observation <- weather(poi = poi, product = "observation", url_only = TRUE)

# Forecast
forecast <- weather(poi = poi, product = "forecast_hourly", url_only = TRUE)

# Astronomy
astronomy <- weather(poi = poi, product = "forecast_astronomy", url_only = TRUE)

# Alerts
alerts <- weather(poi = poi, product = "alerts", url_only = TRUE)
}
\references{
\href{https://developer.here.com/documentation/weather/topics/example-weather-observation.html}{HERE Destination Weather API: Observation}
}
