% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctstm.R
\name{disprog}
\alias{disprog}
\title{Disease progression object}
\description{
An object of class \code{disprog} returned from methods
\verb{$sim_disease()} in model classes. It contains simulated trajectories
through a multi-state model.
}
\section{Components}{

A \code{disprog} object inherits from \code{data.table} and contains
the following columns:

\describe{
\item{sample}{A random sample from the PSA.}
\item{strategy_id}{The treatment strategy ID.}
\item{patient_id}{The patient ID.}
\item{from}{The health state ID transitioned from.}
\item{to}{The health state ID transitioned to.}
\item{final}{An indicator equal to 1 if a patient is in their final health
state during the simulation and 0 otherwise.}
\item{time_start}{The time at the start of the interval.}
\item{time_stop}{The time at the end of the interval.}
}
}

\seealso{
\link{IndivCtstm}, \link{IndivCtstmTrans}
}
