% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hesim_data.R
\name{set_labels}
\alias{set_labels}
\title{Set value labels}
\usage{
set_labels(x, labels, new_names = NULL, as_factor = TRUE)
}
\arguments{
\item{x}{A \code{data.table}.}

\item{labels}{A list of named vectors containing the values and labels of
variables. The elements of each vector are the values of a variable and the
names are the labels. The names of the list are the names of the variables.
See the output returned by \code{\link[=get_labels]{get_labels()}} for an example.}

\item{new_names}{A character vector of the same length as \code{labels} where
each element denotes the name of a new variable to create for the
corresponding element in \code{labels}. If \code{NULL}, then the variables in \code{labels}
are modified and no new variables are created; otherwise, the existing variables
are not modified and new variables are created instead.}

\item{as_factor}{If \code{TRUE} factor variables are created; otherwise character
vectors are created.}
}
\value{
\code{x} is modified by reference and returned invisibly.
}
\description{
Update existing variables or create new ones that replace existing values
with more informative labels as in \code{\link[=factor]{factor()}}. All modifications are performed
by reference (see \code{\link[data.table:set]{data.table::set()}} for more information about assignment by
reference).
}
\examples{
library("data.table")
labs <- list("strategy_id" = c("s1" = 1, 
                               "s2" = 2),
            "grp_id" = c("g1" = 1, 
                         "g2" = 2))
d1 <- data.table(strategy_id = 1:2, grp_id = 1:2)
d2 <- copy(d1); d3 <- copy(d2)
set_labels(d2, labels = labs)
set_labels(d3, labels = labs, new_names = c("strategy_name", "grp_name"))
d1
d2
d3
}
\seealso{
\code{\link[=get_labels]{get_labels()}}
}
