% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_verify_input_data.R
\name{hhcart_verify_input_data}
\alias{hhcart_verify_input_data}
\title{hhcart_verify_input_data verify the input data.}
\usage{
hhcart_verify_input_data(
  X,
  y,
  classify = TRUE,
  max_features_ = 0,
  n_features_ = 0,
  rforest = FALSE
)
}
\arguments{
\item{X}{The training dataset.}

\item{y}{target variable column.}

\item{classify}{Default is TRUE. Set TRUE for a classification problem and FALSE for a regression problem.}

\item{max_features_}{Default is 0. The maximum number of features to search for an optimal split.}

\item{n_features_}{Default is 0. The total number of feature columns in the training dataset.}

\item{rforest}{Default is FALSE. Indicates whether this function is being called from
HHDecisionTree or HHRandomForest.}
}
\value{
Nothing if all checks are passed, otherwise the function stops.
}
\description{
This internal function is used to perform some basic checks on the input dataset. The first check to
fail will stop the model from being instantiated. The following checks are performed:
 - there must be no NA's in the training dataset.
 - all columns in the training datasets must contain numeric data only.
 - max_features must not be greater than n_features.
 - if its a classification problem the target variable must be categorical.
 - if its a regression problem the target variable must not be categorical.
}
