# START


# Function rates() --------------------------------------------------------


# (1) monthly rates

# no time vector supplied:
expect_equal(
  rates(x=c(100,102,105), t=NULL, type="monthly"),
  100*c(NA, 102/100-1, 105/102-1)
)

# with time period:
expect_equal(
  rates(x=c(100,102,105),
        t=as.Date(c("2022-01-01","2022-02-01","2022-03-01")),
        type="monthly"),
  100*c(NA, 102/100-1, 105/102-1)
)

# false time ordering:
expect_equal(
  rates(x=c(100,105,102),
        t=as.Date(c("2022-01-01","2022-03-01","2022-02-01")),
        type="monthly"),
  100*c(NA, 105/102-1, 102/100-1)
)

# (2) annual rates

p <- rnorm(n=24, mean=100)
t <- seq.Date(from=as.Date("2022-01-01"), length.out=length(p), by="1 month")

# no time periods:
expect_equal(
  rates(x=p, t=NULL, type="annual"),
  100*(p/shift(p,n=12)-1)
)

# with time periods:
expect_equal(
  rates(x=p, t=t, type="annual"),
  100*(p/shift(p,n=12)-1)
)

# false time ordering:
t.false <- sample(t)

expect_equal(
  rates(x=p, t=t.false, type="annual"),
  (100*(p[order(t.false)]/shift(p[order(t.false)], n=12)-1))[match(t.false, t)]
)

# (3) annual average rates

# no time periods:
expect_equal(
  rates(x=p, t=NULL, type="annual-average"),
  100*(c(NA, mean(p[13:24])/mean(p[1:12]))-1)
)

# with time periods:
expect_equal(
  rates(x=p, t=t, type="annual-average"),
  100*(c("2022"=NA, "2023"=mean(p[format(t,"%Y")==2023])/mean(p[format(t,"%Y")==2022]))-1)
)

# false time ordering:
t.false <- sample(t)

expect_equal(
  rates(x=p, t=t.false, type="annual-average"),
  100*(c("2022"=NA, "2023"=mean(p[format(t.false,"%Y")==2023])/mean(p[format(t.false,"%Y")==2022]))-1)
)


# Function contrib() ------------------------------------------------------


# check against example in hicp manual

# input:
t <- structure(c(16040, 16071, 16102, 16130, 16161, 16191, 16222,
                 16252, 16283, 16314, 16344, 16375, 16405, 16436, 16467, 16495,
                 16526, 16556, 16587, 16617, 16648, 16679, 16709, 16740, 16770,
                 16801, 16832, 16861, 16892, 16922, 16953, 16983, 17014, 17045,
                 17075, 17106, 17136), class = "Date")
x <- c(108.7, 108.67, 108.74, 108.36, 108.27, 108.2, 108.44, 108.19,
       107.59, 107.75, 106.79, 105.33, 101.85, 98.62, 100.17, 101.91,
       102.01, 102.96, 102.86, 102.14, 99.89, 98.2, 97.68, 97.67, 95.9,
       93.3, 92.07, 93.03, 93.1, 94.64, 96.25, 95.29, 94.29, 95.26,
       96.78, 96.61, 98.35)
x.all <- c(100.11, 98.99, 99.3, 100.23, 100.38, 100.27, 100.38, 99.72,
           99.84, 100.28, 100.22, 100.04, 99.94, 98.4, 99.03, 100.15, 100.39,
           100.61, 100.6, 99.96, 99.97, 100.19, 100.34, 100.19, 100.17,
           98.72, 98.88, 100.11, 100.15, 100.51, 100.68, 100.12, 100.21,
           100.6, 100.85, 100.76, 101.31)
w <- c(NA, 108.07, 108.07, 108.07, 108.07, 108.07, 108.07, 108.07,
       108.07, 108.07, 108.07, 108.07, 108.07, 106.06, 106.06, 106.06,
       106.06, 106.06, 106.06, 106.06, 106.06, 106.06, 106.06, 106.06,
       106.06, 97.4, 97.4, 97.4, 97.4, 97.4, 97.4, 97.4, 97.4, 97.4,
       97.4, 97.4, 97.4)
w.all <- c(NA, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
           1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
           1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
           1000, 1000, 1000, 1000)

# expected results:
ribe.expec <- c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, -1.02529813948425,
                -0.866666250168824, -0.640222130696651, -0.619973954901979, -0.515104491704027,
                -0.548704450433906, -0.602525307493953, -0.776522663065849, -0.964384788894606,
                -0.923621450672416, -0.781068214027195, -0.619594501718212, -0.556492789126052,
                -0.84220466625092, -0.916077474262503, -0.917160195487289, -0.857698005505091,
                -0.684618915689184, -0.711747489267791, -0.579213481076454, -0.303897553214695,
                -0.095393755765013, -0.111760293495743, 0.248832116788319)

kirchner.expec <- c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, -1.01703815303061,
                    -0.861586224084169, -0.641540104650217, -0.622734144979741, -0.518601552711475,
                    -0.552332368477231, -0.602460846904482, -0.777862334822627, -0.968075371900026,
                    -0.927715376510117, -0.783441339089728, -0.619594501718212, -0.553088222076527,
                    -0.838171335760115, -0.91752382926534, -0.918835000771934, -0.861111320893986,
                    -0.688028810561959, -0.711825702057316, -0.580058548982564, -0.305078414197261,
                    -0.0964820271246105, -0.112710625635746, 0.248832116788319)

expect_equal(
  contrib(x=x, w=w, t=t, x.all=x.all, w.all=w.all, method="ribe"),
  ribe.expec
)

expect_equal(
  contrib(x=x, w=w, t=t, x.all=x.all, w.all=w.all, method="kirchner"),
  kirchner.expec
)

# END
