% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcuts.R
\name{hc_add_serie_ts}
\alias{hc_add_serie_ts}
\title{Shorcut for create/add time series from values and dates}
\usage{
hc_add_serie_ts(hc, values, dates, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{values}{A numeric vector}

\item{dates}{A date vector (same length as \code{values})}

\item{...}{Aditional arguments for the data series (\url{http://api.highcharts.com/highcharts#series}).}
}
\description{
This function add a time series to a \code{highchart} object.
}
\details{
This function \bold{modify} the type of \code{chart} to \code{datetime}
}
\examples{

\dontrun{

require("ggplot2")
data(economics, package = "ggplot2")

hc_add_serie_ts(hc = highchart(),
                values = economics$psavert, dates = economics$date,
                name = "Personal Savings Rate")
}

}

