% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc-helpers.R
\name{hc_add_event_point}
\alias{hc_add_event_point}
\alias{hc_add_event_series}
\title{Helpers to use highcharter as input in shiny apps}
\usage{
hc_add_event_point(hc, series = "series", event = "click")

hc_add_event_series(hc, series = "series", event = "click")
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{series}{The name of type of series to apply the event.}

\item{event}{The name of event: click, mouseOut,  mouseOver. See
\url{http://api.highcharts.com/highcharts/plotOptions.areasplinerange.point.events.select}
for more details.}
}
\description{
When you use highcharter in a shiny app, for example
\code{renderHighcharter('my_chart')}, you can access to the actions of the
user using and then use the \code{hc_add_event_point} via the
\code{my_chart} input (\code{input$my_chart}). That's a way you can
use a chart as an input.
}
\note{
Event details are accessible from hc_name_EventType, i.e. if a highchart is rendered against output$my_hc and
and we wanted the coordinates of the user-clicked point we would use input$my_hc_click
}
