% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dethrzbase.R
\name{det_thresholdfromarea_rest}
\alias{det_thresholdfromarea_rest}
\title{Determination of alpha and the threshold c which results
in a high-risk zone with desired area if a hole is present.}
\usage{
det_thresholdfromarea_rest(
  intens,
  areahrz,
  win,
  nxprob = 0.1,
  hole = hole,
  integratehole = TRUE
)
}
\arguments{
\item{intens}{estimated intensity of the observed process (object of class "im", see \code{\link[spatstat.core]{density.ppp}})}

\item{areahrz}{area of the high-risk zone}

\item{win}{observation window}

\item{nxprob}{probability of having unbserved events}

\item{hole}{an object of class \code{owin} representing a region inside the observation window of
the \code{ppdata} where no observations were possible.}

\item{integratehole}{Should the \code{hole} be part of the resulting high-risk zone? Defaults to \code{TRUE}.}
}
\value{
A list of
  \item{ threshold }{ Value of the threshold c. The high-risk zone is the field in which the estimated intensity 
                  exceeds this value }
  \item{ calccutoff }{ failure probability alpha for given area; probability to have at least unobserved event outside the high-risk zone }
}
\description{
This function is used for the intensity-based method. Used in function det_hrz_restr.
}
\seealso{
\code{\link{det_area}}, \code{\link{det_alpha}}
}
