% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2018-02-28.R
\name{chaincheck}
\alias{chaincheck}
\title{Checking the chains on convergence}
\usage{
chaincheck(mids, alpha = 0.01, plot = TRUE)
}
\arguments{
\item{mids}{A mids object generated by hmi
(alternatively a list), having an element called "gibbs" with the chains
of the Gibbs-sampler runs.}

\item{alpha}{A numeric value between 0 and 1 for the desired significance level
of the test on convergence.}

\item{plot}{Logical. Shall the chains be plotted in a traceplot or not.
If the number of iterations and cycles is large, click through all traceplots
can be interminable.}
}
\description{
Formally tests the Gibbs-sampling chains on convergence.
After the burn in is discarded, the remaining iterations of each chain
are tested following Geweke (1992).
In this test, the arithmetic means and their standard errors of the first 10\%
and last 50\% of the chain (from now on always after discarding the burn in)
are compared. In case of a stationary distribution, both means have the same
expected value. The difference between both arithmetic means is divided
 THE ONE (CHECK) standard error.
This is the Z-score, the test statistic.
Chains not passing the test will be plotted.
Each plot will flag which (fixed effect or variance) parameter was tested;
and what variable was to be imputed and the cycle and imputation run.
To see the next plot, the user has to hit <Return> (or "Enter").
}
\references{
J Geweke (1992): Evaluating the accuracy of sampling based approaches
to calculating posterior moments. In Bayesian Statistics 4
(ed. JB Bernando, JO Berger, AP Dawid and Adrian FM Smith) (pp. 169-193).
Clarendon Press, Oxford, UK.
}
