% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape_game.R
\name{scrape_game}
\alias{scrape_game}
\title{Scrape game play-by-play}
\usage{
scrape_game(game_id)
}
\arguments{
\item{game_id}{Game ID to scrape}
}
\value{
A tibble containing event-based play-by-play data for an individual
NHL game. The resulting data will have columns for:
\describe{
\item{event}{String defining the event}
\item{event_type}{String with alternate event definition; in all caps}
\item{secondary_type}{String defining secondary event type}
\item{event_team}{String defining the primary team involved in the event}
\item{event_team_type}{String indicator of event team type: home or away}
\item{description}{String detailed description of event}
\item{period}{Integer value of the game period}
\item{period_seconds}{Numeric value of the seconds into the period of the event}
\item{period_seconds_remaining}{Numeric value of the seconds remaining in the period}
\item{game_seconds}{Numeric value of the seconds into the game of the event}
\item{game_seconds_remaining}{Numeric value of the seconds remaining in the game; negative for overtime periods}
\item{home_score}{Integer value of the home team score after the event}
\item{away_score}{Integer value of the away team score after the event}
\item{event_player_1_name}{String name of the primary event player}
\item{event_player_1_type}{String indicator for the role of event_player_1}
\item{event_player_2_name}{String name of the secondary event player}
\item{event_player_2_type}{String indicator for the role of event_player_2}
\item{event_player_3_name}{String name of the tertiary event player}
\item{event_player_3_type}{String indicator for the role of event_player_3}
\item{event_goalie_name}{String name of the goalie involved in the event}
\item{strength_code}{String indicator for game strength: EV, SH, or PP}
\item{strength}{String name for game strength: Even, Shorthanded, or Power Play}
\item{strength_state}{String name for detailed game strength in the form of '(event team skaters)v(opponent skaters)'}
\item{penalty_minutes}{Integer value of the penalty minutes on penalty events}
\item{penalty_severity}{String name for penalty severity: Minor or Major}
\item{num_on}{Integer value of the number of skaters substituted on during a shift change event}
\item{players_on}{String of player names substituted on during a shift change event}
\item{num_off}{Integer value of the number of skaters substituted off during a shift change event}
\item{players_off}{String of player names substituted off during a shift change event}
\item{extra_attacker}{Logical indicator of whether or not the event team had their goalie pulled}
\item{x}{Numeric x-coordinate of event in feet, with origin at center ice}
\item{y}{Numeric y-coordinate of event in feet, with origin at center ice}
\item{x_fixed}{Numeric transformed x-coordinate of event in feet, where the home team always shoots to the right, away team to the left}
\item{y_fixed}{Numeric transformed y-coordinate of event in feet, where the home team always shoots to the right, away team to the left}
\item{shot_distance}{Numeric distance (in feet) to center of net for unblocked shot events}
\item{shot_angle}{Numeric angle (in degrees) to center of net for unlocked shot events}
\item{home_skaters}{Numeric value for number of skaters on the ice for the home team, excluding the goalie}
\item{away_skaters}{Numeric value for number of skaters on the ice for the away team, excluding the goalie}
\item{home_on_1}{String name of home team player on ice}
\item{home_on_2}{String name of home team player on ice}
\item{home_on_3}{String name of home team player on ice}
\item{home_on_4}{String name of home team player on ice}
\item{home_on_5}{String name of home team player on ice}
\item{home_on_6}{String name of home team player on ice}
\item{home_on_7}{String name of home team player on ice}
\item{away_on_1}{String name of away team player on ice}
\item{away_on_2}{String name of away team player on ice}
\item{away_on_3}{String name of away team player on ice}
\item{away_on_4}{String name of away team player on ice}
\item{away_on_5}{String name of away team player on ice}
\item{away_on_6}{String name of away team player on ice}
\item{away_on_7}{String name of away team player on ice}
\item{home_goalie}{String name of home goalie on ice}
\item{away_goalie}{String name of away goalie on ice}
\item{game_id}{Integer value of assigned game ID}
\item{event_idx}{Numeric index for event}
\item{event_player_1_id}{Integer value of the player ID for the primary event player}
\item{event_player_1_link}{String value of the NHL.com player link for the primary event player}
\item{event_player_1_season_total}{Integer value for the total events for the primary event player this season}
\item{event_player_2_id}{Integer value of the player ID for the secondary event player}
\item{event_player_2_link}{String value of the NHL.com player link for the secondary event player}
\item{event_player_2_season_total}{Integer value for the total events for the secondary event player this season}
\item{event_player_3_id}{Integer value of the player ID for the tertiary event player}
\item{event_player_3_link}{String value of the NHL.com player link for the tertiary event player}
\item{event_player_3_season_total}{Integer value for the total events for the tertiary event player this season}
\item{event_goalie_id}{Integer value of the player ID for the event goalie}
\item{event_goalie_link}{String value of the NHL.com player link for the event goalie}
\item{event_goalie_type}{String indicator for the role of the event_goalie}
\item{game_winning_goal}{Logical indicator of whether or not the goal scored was the game-winning goal}
\item{empty_net}{Logical indicator of whether or not the goal scored was on an empty net}
\item{period_type}{String name of period type: REGULAR, OVERTIME, or SHOOTOUT}
\item{ordinal_num}{String name of the ordinal period: 1st, 2nd, 3rd, 4th...}
\item{period_time}{String value of the time into the period of the event}
\item{period_time_remaining}{String value of the time remaining in the period}
\item{date_time}{String value of the real-world timestamp of the event}
\item{event_team_id}{Integer value of the NHL ID of \code{event_team}}
\item{event_team_link}{String value of the NHL.com team link for the \code{event_team}}
\item{event_team_abbr}{String value of the 3-letter NHL abbreviation for the \code{event_team}}
\item{home_final}{Integer value of the final score for the home team}
\item{away_final}{Integer value of the final score for the away team}
\item{season}{String value of the official NHL season}
\item{season_type}{String indicator of season type: R, or P}
\item{game_date}{Date of game}
\item{game_start}{Date time of start of game in US/Eastern time zone}
\item{game_end}{Date time of end of game in US/Eastern time zone}
\item{game_length}{Period value of length of game, in hours:minutes}
\item{game_state}{String indicator of state of game}
\item{detailed_state}{String indicator of detailed game state}
\item{venue_id}{Integer value of the NHL ID for the venue}
\item{venue_name}{String name of the game venue}
\item{venue_link}{String value of the NHL.com link for the venue}
\item{home_name}{String name of the home team}
\item{home_abbreviation}{String value of the 3-letter NHL abbreviation of the home team}
\item{home_division_name}{String value of the name of the NHL division of the home team}
\item{home_conference_name}{String value of the name of the NHL conference of the home team}
\item{home_id}{Integer value of the NHL ID of the home team}
\item{away_name}{String name of the away team}
\item{away_abbreviation}{String value of the 3-letter NHL abbreviation of the away team}
\item{away_division_name}{String value of the name of the NHL division of the away team}
\item{away_conference_name}{String value of the name of the NHL conference of the away team}
\item{away_id}{Integer value of the NHL ID of the away team}
}
}
\description{
Scrapes play-by-play data for a specified game ID.
}
\examples{
\dontrun{
pbp <- scrape_game(2020020420)
}
}
