% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instrumental_temp.R
\name{plot_temp_monthly}
\alias{plot_temp_monthly}
\title{Download and plot essential climate data}
\usage{
plot_temp_monthly(dataset = get_temp(), print = TRUE)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_temp}}

\item{print}{(boolean) Display temperature anomaly ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with temperature anomaly chart
}
\description{
Plots the monthly mean temperature anomaly retrieved using \code{get_temp()} with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_temp_monthly} invisibly returns a ggplot2 object with a pre-defined temperature monthly mean anomaly chart using data from \code{get_temp}.
By default the chart is also displayed. Smooths using ggplot2's built-in loess smoother. Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Fetch temperature anomaly:
anomaly <- get_temp()
#
# Plot output using package's built-in ggplot2 defaults
plot_temp_monthly(anomaly)

# Or just call plot_temp_monthly(), which defaults to get_temp() dataset
plot_temp_monthly()

p <- plot_temp_monthly(anomaly, print = FALSE)
# Modify plot such as: p + ggplot2::labs(title='The Signature of Climate Change') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
