% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_n3_holland.R
\name{con_n3_holland}
\alias{con_n3_holland}
\title{Congruence Index according to Joerin Fux (2005)}
\usage{
con_n3_holland(a, b)
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}
}
\value{
a numeric with value for congruence.
}
\description{
The function computes the congruence index according to Joerin Fux (2005).
}
\details{
The function finds the congruence according to Joerin Fux (2005) between the up to six-letter Holland-codes given in argument a, which is the person code, and argument b, which is the environment code. The Index as defined by Jörin (2005) targets (only) three letters from the Holland code. The degree of congruence is output, according to its definition by Joerin Fux (2005), as a reciprocal value of a distance. This means, for example, that a value of '3' is the result for a perfect fit of two three-letter codes !
}
\examples{
con_n3_holland(a="RIA",b="SEC") # max. difference 
con_n3_holland(a="RIA",b="RIA") # max. similarity
}
\references{
Holland, J.L. 1963. A theory of vocational choice. I. Vocational images and choice. \emph{Vocational Guidance Quarterly, 11}(4), 232–239.

Joerin Fux, S. (2005). \emph{Persönlichkeit und Berufstätigkeit: Theorie und Instrumente von John Holland im deutschsprachigen Raum, unter Adaptation und Weiterentwicklung von Self-directed Search (SDS) und Position Classification Inventory (PCI)}. 1. Aufl. Göttingen: Cuvillier.
}
\keyword{congruence}
