% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mplus_psyn.R
\name{Mplus_psyn}
\alias{Mplus_psyn}
\title{Generating Mplus syntax for empirical RIASEC angular locations with projected constructs}
\usage{
Mplus_psyn(
  N,
  Cor,
  M,
  mpluserg,
  name = NULL,
  dummyvorl = 1,
  verbose = FALSE,
  eol = "\\r\\n",
  ...
)
}
\arguments{
\item{N}{number of observations for correlations as numeric}

\item{Cor}{either an R matrix object with RIASEC and additional construct correlations or the name of a correlation matrix, stored as a .dat text file, as character (see details).}

\item{M}{number of additional construct dimensions to project into the RIASEC circumplex - e.g. \code{M=5} for big-five personality dimensions}

\item{mpluserg}{name of the Mplus output data (as character - e.g. "myoutput.out") from which the fixation RIASEC-parameters should be read - this is usaly the result of Mplus prosessing an input syntax generated with the function \code{\link{Mplus_esyn}()}.}

\item{name}{optional a name (as character) for the Mplus syntax to be saved - default is the object name or the name given in paramter \code{Cor} as character (with ending changed to '.inp').}

\item{dummyvorl}{default is dummyvorl = 1, which results in the Mplus syntax given in Nagy et. al. (2009). !! don't change this !!
if changed: \emph{"Alternatively, the name of an external dummy template to be used can also be specified here, which is then read in and used. It is strongly recommended to use the internal syntax template, since the use of an external dummy template cannot be documented further here."}.}

\item{verbose}{logical with default set to \code{verbose=FALSE}; if set to \code{verbose=TRUE} the resulting Mplus syntax is \emph{additionally} printed on the console.}

\item{eol}{character see \code{\link{write.table}} to control the generation of correct line endings in text files on different operating systems.}

\item{...}{additional parameters passed through}
}
\value{
resulting Mplus syntax wil be saved in the current working directory
}
\description{
This function generates an extended executable Mplus syntax which is discussed in Nagy et. al. (2009).
the resulting Mplus syntax estimates the angular locations of the six RIASEC dimensions, based on their correlations, in the asumed circumplex array within the theory of vocational choice by John Holland (1997). in contrast to the function \code{\link{Mplus_esyn}()} and the syntax discussed by Nagy et. al. (2009), additional constructs (correlated to RIASEC dimensions) are 'projeted' into the circular array of the six vocational interest dimensions.
}
\details{
for execution of this function it is necessary that you have Mplus (version 6.11 or version 7) installed on your system. The function \code{Mplus_psyn} will read a Mplus output file, located in the current R workspace directory, which is a result of manualy runing an Mplus input file, generatetd by the function \code{\link{Mplus_esyn}()}. The name of the Mplus output data must be specified in the argument \code{mpluserg}.
The structure of the correlation 'data' must follow the structure given in the data \code{\link{example3}} in this package - thus the correlation data must start with the additional construct dimensions which should be projected into the RIASEC circumplex.
}
\examples{
## first preparing an Mplus output data
data(example1) # loading fictional example correlation matrix for fixing
Mplus_esyn(N = 300, Cor = example1)
## !!! now first open the 'example1.inp' with Mplus and click run !!! 
##### not run until Mplus is installed on your system #####
# generating an example Mplus syntax referring to a correlation data 
# stored in the already existing file 'example3' 
# for projection of 5 personality dimensions into the circumplex
data(example3) # loading fictional example correlation matrix with add. constr.
\dontrun{ Mplus_psyn(N = 300, Cor = example3,M = 5, mpluserg = "example1.out") }
################################################################
### clean up work directory
file.remove("example1.inp") # remove generated Mplus syntax from work dir.
file.remove("example1.dat") # remove generated cor. data from work dir.
}
\references{
Holland, J.L. (1997). \emph{Making vocational choices. A theory of vocational personalities and work environments}. Lutz, FL: Psychological Assessment Resources.

Nagy, G., Marsh, H. W., Luedtke, O., & Trautwein, U. (2009). Representing circles in our minds: Confirmatory factor analysis of circumplex structures and profiles. In T. Teo & M. S. Khine (Hrsg.), \emph{Structural Equation Modeling in Educational Research: Concepts and applications} (S. 287 - 315). Rotterdam Boston Taipei: Sense Publishers.
}
\keyword{calculus}
